/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability;

import io.micrometer.tracing.Tracer;
import java.lang.reflect.AnnotatedElement;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.observability.DefaultObservedModule;
import org.springframework.modulith.observability.ModuleEntryInterceptor;
import org.springframework.modulith.observability.ModuleTracingSupport;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.util.Assert;

public class SpringDataRestModuleTracingBeanPostProcessor
extends ModuleTracingSupport
implements BeanPostProcessor {
    private final ApplicationModulesRuntime runtime;
    private final Supplier<Tracer> tracer;

    public SpringDataRestModuleTracingBeanPostProcessor(ApplicationModulesRuntime runtime, Supplier<Tracer> tracer) {
        Assert.notNull((Object)runtime, (String)"ApplicationModulesRuntime must not be null!");
        Assert.notNull(tracer, (String)"Tracer must not be null!");
        this.runtime = runtime;
        this.tracer = tracer;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class type = this.runtime.getUserClass(bean, beanName);
        if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)type, BasePathAwareController.class)) {
            return bean;
        }
        DataRestControllerInterceptor interceptor = new DataRestControllerInterceptor((Supplier<ApplicationModules>)this.runtime, this.tracer);
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor((Advice)interceptor);
        return this.addAdvisor(bean, (Advisor)advisor, it -> it.setProxyTargetClass(true));
    }

    private static class DataRestControllerInterceptor
    implements MethodInterceptor {
        private final Supplier<ApplicationModules> modules;
        private final Supplier<Tracer> tracer;

        private DataRestControllerInterceptor(Supplier<ApplicationModules> modules, Supplier<Tracer> tracer) {
            Assert.notNull(modules, (String)"ApplicationModules must not be null!");
            Assert.notNull(tracer, (String)"Tracer must not be null!");
            this.modules = modules;
            this.tracer = tracer;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            ApplicationModule module = this.getModuleFrom(invocation.getArguments());
            if (module == null) {
                return invocation.proceed();
            }
            DefaultObservedModule observed = new DefaultObservedModule(module);
            return ModuleEntryInterceptor.of(observed, this.tracer.get()).invoke(invocation);
        }

        private ApplicationModule getModuleFrom(Object[] arguments) {
            for (Object argument : arguments) {
                if (!(argument instanceof RootResourceInformation)) continue;
                RootResourceInformation info = (RootResourceInformation)argument;
                return this.modules.get().getModuleByType(info.getDomainType().getName()).orElse(null);
            }
            return null;
        }
    }
}

