/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.platform;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.osgi.test.platform.OsgiPlatform;

abstract class AbstractOsgiPlatform
implements OsgiPlatform {
    private static final String TMP_DIR_FALLBACK = "./tmp-test";
    private static final String DEFAULT_SUFFIX = "osgi";
    private static final String TMP_PREFIX = "org.sfw.osgi";
    final Log log = LogFactory.getLog(this.getClass());
    String toString = this.getClass().getName();
    private Properties configurationProperties = null;

    AbstractOsgiPlatform() {
    }

    public Properties getConfigurationProperties() {
        if (this.configurationProperties == null) {
            this.configurationProperties = new Properties();
            this.configurationProperties.putAll((Map<?, ?>)System.getProperties());
            this.configurationProperties.putAll((Map<?, ?>)this.getPlatformProperties());
            return this.configurationProperties;
        }
        return this.configurationProperties;
    }

    abstract Properties getPlatformProperties();

    public String toString() {
        return this.toString;
    }

    File createTempDir(String suffix) {
        File tempFileName;
        if (suffix == null) {
            suffix = DEFAULT_SUFFIX;
        }
        try {
            tempFileName = File.createTempFile(TMP_PREFIX, suffix);
        }
        catch (IOException ex) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"Could not create temporary directory, returning a temp folder inside the current folder", (Throwable)ex);
            }
            return new File(TMP_DIR_FALLBACK);
        }
        tempFileName.delete();
        File tempFolder = new File(tempFileName.getAbsolutePath());
        tempFolder.mkdir();
        return tempFolder;
    }
}

