/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.platform;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.main.AutoActivator;
import org.apache.felix.main.Main;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.test.internal.util.IOUtils;
import org.springframework.osgi.test.platform.AbstractOsgiPlatform;

public class FelixPlatform
extends AbstractOsgiPlatform {
    private static final Log log = LogFactory.getLog((Class)FelixPlatform.class);
    private static final String FELIX_PROFILE_DIR_PROPERTY = "felix.cache.profiledir";
    private static final String OSGI_STORAGE_PROPERTY = "org.osgi.framework.storage";
    private BundleContext context;
    private Felix platform;
    private File felixStorageDir;

    public FelixPlatform() {
        this.toString = "Felix OSGi Platform";
    }

    Properties getPlatformProperties() {
        Properties props = new Properties();
        this.createStorageDir(props);
        props.put("felix.log.level", "0");
        props.put("felix.embedded.execution", "true");
        return props;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    private void createStorageDir(Properties configProperties) {
        if (this.felixStorageDir == null) {
            this.felixStorageDir = this.createTempDir("felix");
            this.felixStorageDir.deleteOnExit();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Felix storage dir is " + this.felixStorageDir.getAbsolutePath()));
            }
        }
        configProperties.setProperty(FELIX_PROFILE_DIR_PROPERTY, this.felixStorageDir.getAbsolutePath());
        configProperties.setProperty(OSGI_STORAGE_PROPERTY, this.felixStorageDir.getAbsolutePath());
    }

    public void start() throws Exception {
        if (this.platform == null) {
            System.getProperties().putAll((Map<?, ?>)this.getConfigurationProperties());
            this.platform = this.configureFelix();
            this.platform.start();
            this.context = this.platform.getBundleContext();
        }
    }

    private Felix configureFelix() throws Exception {
        boolean is14 = false;
        Constructor ctr = null;
        try {
            ctr = Felix.class.getConstructor(Map.class);
            is14 = true;
        }
        catch (NoSuchMethodException nsme) {
            ctr = Felix.class.getConstructor(Map.class, List.class);
        }
        Object[] params = this.commonFelixSetup();
        return is14 ? this.configureFelix14X(ctr, params) : this.configureFelix10X_12X(ctr, params);
    }

    private Felix configureFelix10X_12X(Constructor ctr, Object[] params) throws Exception {
        StringMap configMap = new StringMap((Map)params[0], false);
        return (Felix)ctr.newInstance(configMap, params[1]);
    }

    private Felix configureFelix14X(Constructor ctr, Object[] params) throws Exception {
        Map configProps = (Map)params[0];
        configProps.put("felix.systembundle.activators", params[1]);
        return (Felix)ctr.newInstance(configProps);
    }

    private Object[] commonFelixSetup() {
        Main.loadSystemProperties();
        Properties configProps = Main.loadConfigProperties();
        if (configProps == null) {
            configProps = new Properties();
        }
        Main.copySystemProperties((Properties)configProps);
        ArrayList<AutoActivator> list = new ArrayList<AutoActivator>(1);
        list.add(new AutoActivator((Map)configProps));
        return new Object[]{configProps, list};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.platform != null) {
            try {
                this.platform.stop();
            }
            finally {
                this.context = null;
                this.platform = null;
                IOUtils.delete(this.felixStorageDir);
            }
        }
    }
}

