/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.internal.support;

import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.web.deployer.WarDeploymentContext;
import org.springframework.util.Assert;

public class DefaultWarDeploymentContext
implements WarDeploymentContext {
    private final Bundle bundle;
    private final String contextPath;
    private final ServletContext servletContext;

    public DefaultWarDeploymentContext(Bundle bundle, String contextPath, ServletContext servletContext) {
        Assert.notNull((Object)bundle, (String)"bundle is required");
        Assert.hasText((String)contextPath, (String)"a valid contextPath is required");
        Assert.notNull((Object)servletContext, (String)"servletContext is required");
        this.bundle = bundle;
        this.contextPath = contextPath;
        this.servletContext = servletContext;
        this.servletContext.setAttribute(WarDeploymentContext.OSGI_BUNDLE_CONTEXT_ATTRIBUTE, (Object)OsgiBundleUtils.getBundleContext((Bundle)bundle));
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

