/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.reactive.config.AbstractReactivePulsarListenerEndpoint;
import org.springframework.pulsar.reactive.config.ReactivePulsarListenerContainerFactory;
import org.springframework.pulsar.reactive.config.ReactivePulsarListenerEndpoint;
import org.springframework.pulsar.reactive.core.ReactivePulsarConsumerFactory;
import org.springframework.pulsar.reactive.listener.DefaultReactivePulsarMessageListenerContainer;
import org.springframework.pulsar.reactive.listener.ReactivePulsarContainerProperties;
import org.springframework.pulsar.support.JavaUtils;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultReactivePulsarListenerContainerFactory<T>
implements ReactivePulsarListenerContainerFactory<T> {
    private static final String SUBSCRIPTION_NAME_PREFIX = "org.springframework.Pulsar.ReactivePulsarListenerEndpointContainer#";
    private static final AtomicInteger COUNTER = new AtomicInteger();
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    private final ReactivePulsarConsumerFactory<T> consumerFactory;
    private final ReactivePulsarContainerProperties<T> containerProperties;
    private Boolean autoStartup;
    private MessageConverter messageConverter;
    private Boolean fluxListener;

    public DefaultReactivePulsarListenerContainerFactory(ReactivePulsarConsumerFactory<T> consumerFactory, ReactivePulsarContainerProperties<T> containerProperties) {
        this.consumerFactory = consumerFactory;
        this.containerProperties = containerProperties;
    }

    protected ReactivePulsarConsumerFactory<T> getConsumerFactory() {
        return this.consumerFactory;
    }

    public ReactivePulsarContainerProperties<T> getContainerProperties() {
        return this.containerProperties;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setFluxListener(Boolean fluxListener) {
        this.fluxListener = fluxListener;
    }

    public DefaultReactivePulsarMessageListenerContainer<T> createContainerInstance(ReactivePulsarListenerEndpoint<T> endpoint) {
        ReactivePulsarContainerProperties containerProps = new ReactivePulsarContainerProperties();
        ReactivePulsarContainerProperties<T> factoryProps = this.getContainerProperties();
        containerProps.setSchemaResolver(factoryProps.getSchemaResolver());
        containerProps.setTopicResolver(factoryProps.getTopicResolver());
        containerProps.setSubscriptionType(factoryProps.getSubscriptionType());
        containerProps.setSubscriptionName(factoryProps.getSubscriptionName());
        containerProps.setSchemaType(factoryProps.getSchemaType());
        containerProps.setConcurrency(factoryProps.getConcurrency());
        containerProps.setUseKeyOrderedProcessing(factoryProps.isUseKeyOrderedProcessing());
        if (!CollectionUtils.isEmpty((Collection)endpoint.getTopics())) {
            containerProps.setTopics(endpoint.getTopics());
        }
        if (StringUtils.hasText((String)endpoint.getTopicPattern())) {
            containerProps.setTopicsPattern(endpoint.getTopicPattern());
        }
        if (endpoint.getSubscriptionType() != null) {
            containerProps.setSubscriptionType(endpoint.getSubscriptionType());
        }
        if (containerProps.getSubscriptionType() == null) {
            containerProps.setSubscriptionType(SubscriptionType.Exclusive);
        }
        if (StringUtils.hasText((String)endpoint.getSubscriptionName())) {
            containerProps.setSubscriptionName(endpoint.getSubscriptionName());
        }
        if (!StringUtils.hasText((String)containerProps.getSubscriptionName())) {
            String generatedName = SUBSCRIPTION_NAME_PREFIX + COUNTER.getAndIncrement();
            containerProps.setSubscriptionName(generatedName);
        }
        if (endpoint.getSchemaType() != null) {
            containerProps.setSchemaType(endpoint.getSchemaType());
        }
        if (containerProps.getSchema() == null) {
            containerProps.setSchema(Schema.BYTES);
        }
        if (endpoint.getConcurrency() != null) {
            containerProps.setConcurrency(endpoint.getConcurrency());
        }
        if (endpoint.getUseKeyOrderedProcessing() != null) {
            containerProps.setUseKeyOrderedProcessing(endpoint.getUseKeyOrderedProcessing());
        }
        return new DefaultReactivePulsarMessageListenerContainer<T>(this.getConsumerFactory(), containerProps);
    }

    public DefaultReactivePulsarMessageListenerContainer<T> createRegisteredContainer(ReactivePulsarListenerEndpoint<T> endpoint) {
        AbstractReactivePulsarListenerEndpoint abstractReactiveEndpoint;
        DefaultReactivePulsarMessageListenerContainer<T> instance = this.createContainerInstance(endpoint);
        if (endpoint instanceof AbstractReactivePulsarListenerEndpoint && (abstractReactiveEndpoint = (AbstractReactivePulsarListenerEndpoint)endpoint).getFluxListener() == null) {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.fluxListener, abstractReactiveEndpoint::setFluxListener);
        }
        endpoint.setupListenerContainer(instance, this.messageConverter);
        this.initializeContainer(instance, endpoint);
        return instance;
    }

    public DefaultReactivePulsarMessageListenerContainer<T> createContainer(final String ... topics) {
        ReactivePulsarListenerEndpoint endpoint = new ReactivePulsarListenerEndpoint<T>(){

            public List<String> getTopics() {
                return Arrays.asList(topics);
            }
        };
        DefaultReactivePulsarMessageListenerContainer<T> container = this.createContainerInstance(endpoint);
        this.initializeContainer(container, endpoint);
        return container;
    }

    private void initializeContainer(DefaultReactivePulsarMessageListenerContainer<T> instance, ReactivePulsarListenerEndpoint<T> endpoint) {
        Boolean autoStart = endpoint.getAutoStartup();
        if (autoStart != null) {
            instance.setAutoStartup(autoStart);
        } else if (this.autoStartup != null) {
            instance.setAutoStartup(this.autoStartup);
        }
    }
}

