/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.function;

import javax.annotation.Nullable;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.io.SourceConfig;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.function.PulsarFunctionOperations;

public record PulsarSource(SourceConfig config, PulsarFunctionOperations.FunctionStopPolicy stopPolicy, @Nullable UpdateOptions updateOptions) implements PulsarFunctionOperations<SourceConfig>
{
    public PulsarSource(SourceConfig config, @Nullable UpdateOptions updateOptions) {
        this(config, PulsarFunctionOperations.FunctionStopPolicy.DELETE, updateOptions);
    }

    @Override
    public String name() {
        return this.config().getName();
    }

    @Override
    public PulsarFunctionOperations.FunctionType type() {
        return PulsarFunctionOperations.FunctionType.SOURCE;
    }

    @Override
    public String archive() {
        return this.config().getArchive();
    }

    @Override
    public SourceConfig get(PulsarAdmin admin) throws PulsarAdminException {
        return admin.sources().getSource(this.config().getTenant(), this.config().getNamespace(), this.config().getName());
    }

    @Override
    public void updateWithUrl(PulsarAdmin admin) throws PulsarAdminException {
        admin.sources().updateSourceWithUrl(this.config(), this.archive(), this.updateOptions());
    }

    @Override
    public void update(PulsarAdmin admin) throws PulsarAdminException {
        admin.sources().updateSource(this.config(), this.archive(), this.updateOptions());
    }

    @Override
    public void createWithUrl(PulsarAdmin admin) throws PulsarAdminException {
        admin.sources().createSourceWithUrl(this.config(), this.archive());
    }

    @Override
    public void create(PulsarAdmin admin) throws PulsarAdminException {
        admin.sources().createSource(this.config(), this.archive());
    }

    @Override
    public void stop(PulsarAdmin admin) {
        try {
            admin.sources().stopSource(this.config().getTenant(), this.config().getNamespace(), this.config().getName());
        }
        catch (PulsarAdminException e) {
            throw new PulsarException(e.getMessage(), e);
        }
    }

    @Override
    public void delete(PulsarAdmin admin) {
        try {
            admin.sources().deleteSource(this.config().getTenant(), this.config().getNamespace(), this.config().getName());
        }
        catch (PulsarAdminException e) {
            throw new PulsarException(e.getMessage(), e);
        }
    }
}

