/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener.adapter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.Reader;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.MethodParameter;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.pulsar.listener.adapter.HandlerAdapter;
import org.springframework.pulsar.support.converter.PulsarMessageConverter;
import org.springframework.pulsar.support.converter.PulsarRecordMessageConverter;
import org.springframework.pulsar.support.header.JsonPulsarHeaderMapper;
import org.springframework.util.Assert;

public abstract class AbstractPulsarMessageToSpringMessageAdapter<V> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final Object bean;
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    private final Type inferredType;
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private HandlerAdapter handlerMethod;
    private boolean headerFound = false;
    private boolean simpleExtraction = false;
    private boolean isPulsarMessageList;
    private boolean isSpringMessageList;
    private boolean isSpringMessageFlux;
    private boolean isSpringMessage;
    private boolean isConsumerRecords;
    private boolean customConverterSet;
    private PulsarMessageConverter<V> messageConverter;
    private Type fallbackType = Object.class;

    public AbstractPulsarMessageToSpringMessageAdapter(Object bean, Method method) {
        this.bean = bean;
        this.messageConverter = new PulsarRecordMessageConverter(JsonPulsarHeaderMapper.builder().build());
        this.inferredType = this.determineInferredType(method);
    }

    public void setMessageConverter(PulsarMessageConverter<V> messageConverter) {
        this.messageConverter = messageConverter;
        this.customConverterSet = true;
    }

    protected final PulsarMessageConverter<V> getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessagingConverter(SmartMessageConverter messageConverter) {
        Assert.isTrue((!this.customConverterSet ? 1 : 0) != 0, (String)"Cannot set the SmartMessageConverter on a custom messageConverter - add the SmartConverter to the custom converter instead");
        ((PulsarRecordMessageConverter)this.messageConverter).setMessagingConverter(messageConverter);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.isTrue((!this.customConverterSet ? 1 : 0) != 0, (String)"Cannot set the ObjectMapper on a custom messageConverter - set the ObjectMapper on the custom converter instead");
        this.messageConverter = new PulsarRecordMessageConverter(JsonPulsarHeaderMapper.builder().objectMapper(objectMapper).build());
    }

    protected Type getType() {
        return this.inferredType == null ? this.fallbackType : this.inferredType;
    }

    public void setFallbackType(Class<?> fallbackType) {
        this.fallbackType = fallbackType;
    }

    public void setHandlerMethod(HandlerAdapter handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    protected boolean isPulsarMessageList() {
        return this.isPulsarMessageList;
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.evaluationContext.setBeanResolver(beanResolver);
        this.evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter());
        this.evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }

    protected boolean isMessageList() {
        return this.isSpringMessageList;
    }

    protected boolean isSpringMessageFlux() {
        return this.isSpringMessageFlux;
    }

    protected org.springframework.messaging.Message<?> toMessagingMessage(Message<V> record, Consumer<V> consumer) {
        return this.getMessageConverter().toMessage(record, consumer, this.getType());
    }

    protected org.springframework.messaging.Message<?> toMessagingMessageFromReader(Message<V> record, Reader<V> reader) {
        return this.getMessageConverter().toMessageFromReader(record, reader, this.getType());
    }

    protected final Object invokeHandler(org.springframework.messaging.Message<?> message, Object ... providedArgs) {
        try {
            return this.handlerMethod.invoke(message, providedArgs);
        }
        catch (Exception ex) {
            throw new MessageConversionException("Cannot handle message", (Throwable)ex);
        }
    }

    protected Type determineInferredType(Method method) {
        Type parameterType;
        MethodParameter methodParameter;
        int i;
        if (method == null) {
            return null;
        }
        Type genericParameterType = null;
        boolean pulsarMessageFound = false;
        boolean collectionFound = false;
        for (i = 0; i < method.getParameterCount(); ++i) {
            methodParameter = new MethodParameter(method, i);
            parameterType = methodParameter.getGenericParameterType();
            if (methodParameter.hasParameterAnnotation(Header.class)) {
                this.headerFound = true;
                continue;
            }
            if (this.parameterIsType(parameterType, (Type)((Object)org.springframework.messaging.Message.class))) {
                this.isSpringMessage = true;
                continue;
            }
            if (this.parameterIsType(parameterType, (Type)((Object)Message.class))) {
                pulsarMessageFound = true;
                continue;
            }
            if (!this.isMultipleMessageType(parameterType)) continue;
            collectionFound = true;
        }
        if (!(this.headerFound || this.isSpringMessage || pulsarMessageFound || collectionFound)) {
            this.simpleExtraction = true;
        }
        for (i = 0; i < method.getParameterCount(); ++i) {
            methodParameter = new MethodParameter(method, i);
            parameterType = methodParameter.getGenericParameterType();
            boolean isNotConvertible = this.parameterIsType(parameterType, (Type)((Object)Message.class));
            if (isNotConvertible || this.isMessageWithNoTypeInfo(parameterType) || methodParameter.getParameterAnnotations().length != 0 && !methodParameter.hasParameterAnnotation(Payload.class)) continue;
            if (genericParameterType == null) {
                genericParameterType = this.extractGenericParameterTypFromMethodParameter(methodParameter);
                continue;
            }
            this.logger.debug(() -> "Ambiguous parameters for target payload for method " + method + "; no inferred type available");
            break;
        }
        return genericParameterType;
    }

    protected boolean isMultipleMessageType(Type type) {
        return this.parameterIsType(type, (Type)((Object)List.class)) || this.parameterIsType(type, (Type)((Object)Messages.class));
    }

    private Type extractGenericParameterTypFromMethodParameter(MethodParameter methodParameter) {
        Type genericParameterType = methodParameter.getGenericParameterType();
        if (genericParameterType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericParameterType;
            if (parameterizedType.getRawType().equals(org.springframework.messaging.Message.class)) {
                genericParameterType = ((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
            } else if (parameterizedType.getRawType().equals(List.class) && parameterizedType.getActualTypeArguments().length == 1) {
                Type paramType = parameterizedType.getActualTypeArguments()[0];
                this.isPulsarMessageList = paramType instanceof ParameterizedType && ((ParameterizedType)paramType).getRawType().equals(Message.class);
                boolean messageHasGeneric = paramType instanceof ParameterizedType && ((ParameterizedType)paramType).getRawType().equals(org.springframework.messaging.Message.class);
                boolean bl = this.isSpringMessageList = paramType.equals(org.springframework.messaging.Message.class) || messageHasGeneric;
                if (messageHasGeneric) {
                    genericParameterType = ((ParameterizedType)paramType).getActualTypeArguments()[0];
                }
                if (!(this.isSpringMessageList || this.isPulsarMessageList || this.isHeaderFound())) {
                    this.simpleExtraction = true;
                }
            } else if (this.isFlux(parameterizedType.getRawType()) && parameterizedType.getActualTypeArguments().length == 1) {
                Type paramType = parameterizedType.getActualTypeArguments()[0];
                boolean messageHasGeneric = paramType instanceof ParameterizedType && ((ParameterizedType)paramType).getRawType().equals(org.springframework.messaging.Message.class);
                boolean bl = this.isSpringMessageFlux = paramType.equals(org.springframework.messaging.Message.class) || messageHasGeneric;
                if (messageHasGeneric) {
                    genericParameterType = ((ParameterizedType)paramType).getActualTypeArguments()[0];
                }
            } else {
                this.isConsumerRecords = parameterizedType.getRawType().equals(Messages.class);
            }
        }
        return genericParameterType;
    }

    protected boolean isFlux(Type type) {
        return false;
    }

    protected boolean parameterIsType(Type parameterType, Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (parameterType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)parameterType).getRawType()).equals(type)) {
            return true;
        }
        return parameterType.equals(type);
    }

    private boolean isMessageWithNoTypeInfo(Type parameterType) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (parameterType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)parameterType).getRawType()).equals(org.springframework.messaging.Message.class)) {
            return parameterizedType.getActualTypeArguments()[0] instanceof WildcardType;
        }
        return parameterType.equals(org.springframework.messaging.Message.class);
    }

    public boolean isSimpleExtraction() {
        return this.simpleExtraction;
    }

    public boolean isConsumerRecords() {
        return this.isConsumerRecords;
    }

    public boolean isHeaderFound() {
        return this.headerFound;
    }

    public boolean isSpringMessage() {
        return this.isSpringMessage;
    }
}

