/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrySimulation {
    private final List<SleepSequence> sleepSequences = new ArrayList<SleepSequence>();
    private final Map<Long, Long> sleepHistogram = new HashMap<Long, Long>();

    public void addSequence(List<Long> sleeps) {
        for (Long sleep : sleeps) {
            Long existingHisto = this.sleepHistogram.get(sleep);
            if (existingHisto == null) {
                this.sleepHistogram.put(sleep, 1L);
                continue;
            }
            this.sleepHistogram.put(sleep, existingHisto + 1L);
        }
        this.sleepSequences.add(new SleepSequence(sleeps));
    }

    public List<Long> getUniqueSleeps() {
        ArrayList<Long> res = new ArrayList<Long>(this.sleepHistogram.keySet());
        Collections.sort(res);
        return res;
    }

    public List<Long> getUniqueSleepsHistogram() {
        ArrayList<Long> res = new ArrayList<Long>(this.sleepHistogram.size());
        for (Long sleep : this.getUniqueSleeps()) {
            res.add(this.sleepHistogram.get(sleep));
        }
        return res;
    }

    public SleepSequence getLongestTotalSleepSequence() {
        SleepSequence longest = null;
        for (SleepSequence sequence : this.sleepSequences) {
            if (longest != null && sequence.getTotalSleep() <= longest.getTotalSleep()) continue;
            longest = sequence;
        }
        return longest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SleepSequence {
        private final List<Long> sleeps;
        private final long longestSleep;
        private final long totalSleep;

        public SleepSequence(List<Long> sleeps) {
            this.sleeps = sleeps;
            this.longestSleep = Collections.max(sleeps);
            long totalSleep = 0L;
            for (Long sleep : sleeps) {
                totalSleep += sleep.longValue();
            }
            this.totalSleep = totalSleep;
        }

        public List<Long> getSleeps() {
            return this.sleeps;
        }

        public long getLongestSleep() {
            return this.longestSleep;
        }

        public long getTotalSleep() {
            return this.totalSleep;
        }

        public String toString() {
            return "totalSleep=" + this.totalSleep + ": " + this.sleeps.toString();
        }
    }
}

