/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRedirectResolver
implements RedirectResolver {
    private Collection<String> redirectGrantTypes = Arrays.asList("implicit", "authorization_code");

    public void setRedirectGrantTypes(Collection<String> redirectGrantTypes) {
        this.redirectGrantTypes = new HashSet<String>(redirectGrantTypes);
    }

    @Override
    public String resolveRedirect(String requestedRedirect, ClientDetails client) throws OAuth2Exception {
        Set<String> authorizedGrantTypes = client.getAuthorizedGrantTypes();
        if (authorizedGrantTypes.isEmpty()) {
            throw new InvalidGrantException("A client must have at least one authorized grant type.");
        }
        if (!this.containsRedirectGrantType(authorizedGrantTypes)) {
            throw new InvalidGrantException("A redirect_uri can only be used by implicit or authorization_code grant types.");
        }
        Set<String> redirectUris = client.getRegisteredRedirectUri();
        if (redirectUris != null && !redirectUris.isEmpty()) {
            return this.obtainMatchingRedirect(redirectUris, requestedRedirect);
        }
        if (StringUtils.hasText((String)requestedRedirect)) {
            return requestedRedirect;
        }
        throw new RedirectMismatchException("A redirect_uri must be supplied.");
    }

    private boolean containsRedirectGrantType(Set<String> grantTypes) {
        for (String type : grantTypes) {
            if (!this.redirectGrantTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    protected boolean redirectMatches(String requestedRedirect, String redirectUri) {
        return requestedRedirect.startsWith(redirectUri);
    }

    private String obtainMatchingRedirect(Set<String> redirectUris, String requestedRedirect) {
        Assert.notEmpty(redirectUris, (String)"Redirect URIs cannot be empty");
        if (redirectUris.size() == 1 && requestedRedirect == null) {
            return redirectUris.iterator().next();
        }
        for (String redirectUri : redirectUris) {
            if (requestedRedirect == null || !this.redirectMatches(requestedRedirect, redirectUri)) continue;
            return requestedRedirect;
        }
        throw new RedirectMismatchException("Invalid redirect: " + requestedRedirect + " does not match one of the registered values: " + redirectUris.toString());
    }
}

