/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.client;

import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class ClientCredentialsTokenGranter
extends AbstractTokenGranter {
    private static final String GRANT_TYPE = "client_credentials";

    public ClientCredentialsTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService) {
        super(tokenServices, clientDetailsService, GRANT_TYPE);
    }

    public OAuth2AccessToken grant(String grantType, AuthorizationRequest authorizationRequest) {
        OAuth2AccessToken token = super.grant(grantType, authorizationRequest);
        if (token != null) {
            DefaultOAuth2AccessToken norefresh = new DefaultOAuth2AccessToken(token);
            norefresh.setRefreshToken(null);
            token = norefresh;
        }
        return token;
    }
}

