/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.code;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationRequestHolder;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class AuthorizationCodeTokenGranter
extends AbstractTokenGranter {
    private static final String GRANT_TYPE = "authorization_code";
    private final AuthorizationCodeServices authorizationCodeServices;

    public AuthorizationCodeTokenGranter(AuthorizationServerTokenServices tokenServices, AuthorizationCodeServices authorizationCodeServices, ClientDetailsService clientDetailsService) {
        super(tokenServices, clientDetailsService, GRANT_TYPE);
        this.authorizationCodeServices = authorizationCodeServices;
    }

    protected OAuth2Authentication getOAuth2Authentication(AuthorizationRequest authorizationRequest) {
        Map<String, String> parameters = authorizationRequest.getAuthorizationParameters();
        String authorizationCode = parameters.get("code");
        String redirectUri = parameters.get("redirect_uri");
        if (authorizationCode == null) {
            throw new OAuth2Exception("An authorization code must be supplied.");
        }
        AuthorizationRequestHolder storedAuth = this.authorizationCodeServices.consumeAuthorizationCode(authorizationCode);
        if (storedAuth == null) {
            throw new InvalidGrantException("Invalid authorization code: " + authorizationCode);
        }
        AuthorizationRequest pendingAuthorizationRequest = storedAuth.getAuthenticationRequest();
        String redirectUriApprovalParameter = pendingAuthorizationRequest.getAuthorizationParameters().get("redirect_uri");
        if (!(redirectUri == null && redirectUriApprovalParameter == null || pendingAuthorizationRequest.getRedirectUri().equals(redirectUri))) {
            throw new RedirectMismatchException("Redirect URI mismatch.");
        }
        String pendingClientId = pendingAuthorizationRequest.getClientId();
        String clientId = authorizationRequest.getClientId();
        if (clientId != null && !clientId.equals(pendingClientId)) {
            throw new InvalidClientException("Client ID mismatch");
        }
        HashMap<String, String> combinedParameters = new HashMap<String, String>(storedAuth.getAuthenticationRequest().getAuthorizationParameters());
        combinedParameters.putAll(parameters);
        DefaultAuthorizationRequest outgoingRequest = new DefaultAuthorizationRequest(pendingAuthorizationRequest);
        outgoingRequest.setAuthorizationParameters(combinedParameters);
        Authentication userAuth = storedAuth.getUserAuthentication();
        return new OAuth2Authentication(outgoingRequest, userAuth);
    }
}

