/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.expression;

import java.util.Collection;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

public abstract class OAuth2ExpressionUtils {
    public static boolean clientHasAnyRole(Authentication authentication, String ... roles) {
        AuthorizationRequest clientAuthentication;
        Collection<GrantedAuthority> clientAuthorities;
        if (authentication instanceof OAuth2Authentication && (clientAuthorities = (clientAuthentication = ((OAuth2Authentication)authentication).getAuthorizationRequest()).getAuthorities()) != null) {
            Set roleSet = AuthorityUtils.authorityListToSet(clientAuthorities);
            for (String role : roles) {
                if (!roleSet.contains(role)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOAuth(Authentication authentication) {
        return authentication instanceof OAuth2Authentication;
    }

    public static boolean isOAuthClientAuth(Authentication authentication) {
        if (authentication instanceof OAuth2Authentication) {
            return authentication.isAuthenticated() && ((OAuth2Authentication)authentication).isClientOnly();
        }
        return false;
    }

    public static boolean isOAuthUserAuth(Authentication authentication) {
        if (authentication instanceof OAuth2Authentication) {
            return authentication.isAuthenticated() && !((OAuth2Authentication)authentication).isClientOnly();
        }
        return false;
    }

    public static boolean hasAnyScope(Authentication authentication, String[] scopes) {
        AuthorizationRequest clientAuthentication;
        Set<String> assigned;
        if (authentication instanceof OAuth2Authentication && (assigned = (clientAuthentication = ((OAuth2Authentication)authentication).getAuthorizationRequest()).getScope()) != null) {
            for (String scope : scopes) {
                if (!assigned.contains(scope)) continue;
                return true;
            }
        }
        return false;
    }
}

