/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class FrameworkEndpointHandlerMapping
extends RequestMappingHandlerMapping {
    private static final String REDIRECT = "redirect:";
    private static final String FORWARD = "forward:";
    private Map<String, String> mappings = new HashMap<String, String>();
    private String approvalParameter = "user_oauth_approval";
    private Set<String> paths = new HashSet<String>();
    private String prefix;

    public void setPrefix(String prefix) {
        if (!StringUtils.hasText((String)prefix)) {
            prefix = "";
        } else {
            while (prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.lastIndexOf("/"));
            }
        }
        this.prefix = prefix;
    }

    public void setMappings(Map<String, String> patternMap) {
        this.mappings = new HashMap<String, String>(patternMap);
        for (String key : this.mappings.keySet()) {
            String result = this.mappings.get(key);
            if (result.startsWith(FORWARD)) {
                result = result.substring(FORWARD.length());
            }
            if (result.startsWith(REDIRECT)) {
                result = result.substring(REDIRECT.length());
            }
            this.mappings.put(key, result);
        }
    }

    public String getServletPath(String defaultPath) {
        return (this.prefix == null ? "" : this.prefix) + this.getPath(defaultPath);
    }

    public String getPath(String defaultPath) {
        String result = defaultPath;
        if (this.mappings.containsKey(defaultPath)) {
            result = this.mappings.get(defaultPath);
        }
        return result;
    }

    public Set<String> getPaths() {
        return this.paths;
    }

    public void setApprovalParameter(String approvalParameter) {
        this.approvalParameter = approvalParameter;
    }

    public FrameworkEndpointHandlerMapping() {
        this.setOrder(0x7FFFFFFD);
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, FrameworkEndpoint.class) != null;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo defaultMapping = super.getMappingForMethod(method, handlerType);
        if (defaultMapping == null) {
            return null;
        }
        Set defaultPatterns = defaultMapping.getPatternsCondition().getPatterns();
        String[] patterns = new String[defaultPatterns.size()];
        int i = 0;
        for (String pattern : defaultPatterns) {
            patterns[i] = this.getPath(pattern);
            this.paths.add(pattern);
            ++i;
        }
        PatternsRequestCondition patternsInfo = new PatternsRequestCondition(patterns, this.getUrlPathHelper(), this.getPathMatcher(), this.useSuffixPatternMatch(), this.useTrailingSlashMatch(), this.getFileExtensions());
        ParamsRequestCondition paramsInfo = defaultMapping.getParamsCondition();
        if (!this.approvalParameter.equals("user_oauth_approval") && defaultPatterns.contains("/oauth/authorize")) {
            String[] params = new String[paramsInfo.getExpressions().size()];
            Set expressions = paramsInfo.getExpressions();
            i = 0;
            for (NameValueExpression expression : expressions) {
                String param = expression.toString();
                params[i] = "user_oauth_approval".equals(param) ? this.approvalParameter : param;
                ++i;
            }
            paramsInfo = new ParamsRequestCondition(params);
        }
        RequestMappingInfo mapping = new RequestMappingInfo(patternsInfo, defaultMapping.getMethodsCondition(), paramsInfo, defaultMapping.getHeadersCondition(), defaultMapping.getConsumesCondition(), defaultMapping.getProducesCondition(), defaultMapping.getCustomCondition());
        return mapping;
    }
}

