/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.security.acls.AccessControlEntry;
import org.springframework.security.acls.Acl;
import org.springframework.security.acls.MutableAcl;
import org.springframework.security.acls.NotFoundException;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.UnloadedSidException;
import org.springframework.security.acls.domain.AbstractRegisteredPermission;
import org.springframework.security.acls.domain.AccessControlEntryImpl;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.jdbc.AclCache;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.acls.objectidentity.ObjectIdentityImpl;
import org.springframework.security.acls.sid.GrantedAuthoritySid;
import org.springframework.security.acls.sid.PrincipalSid;
import org.springframework.security.acls.sid.Sid;
import org.springframework.security.util.FieldUtils;
import org.springframework.util.Assert;

public final class BasicLookupStrategy
implements LookupStrategy {
    private AclAuthorizationStrategy aclAuthorizationStrategy;
    private AclCache aclCache;
    private AuditLogger auditLogger;
    private JdbcTemplate jdbcTemplate;
    private int batchSize = 50;
    static /* synthetic */ Class class$org$springframework$security$acls$domain$AclImpl;
    static /* synthetic */ Class class$java$lang$Long;

    public BasicLookupStrategy(DataSource dataSource, AclCache aclCache, AclAuthorizationStrategy aclAuthorizationStrategy, AuditLogger auditLogger) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        Assert.notNull((Object)aclCache, (String)"AclCache required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        Assert.notNull((Object)auditLogger, (String)"AuditLogger required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.aclCache = aclCache;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.auditLogger = auditLogger;
    }

    private static String computeRepeatingSql(String repeatingSql, int requiredRepetitions) {
        Assert.isTrue((requiredRepetitions >= 1 ? 1 : 0) != 0, (String)"Must be => 1");
        String startSql = "select acl_object_identity.object_id_identity, acl_entry.ace_order,  acl_object_identity.id as acl_id, acl_object_identity.parent_object, acl_object_identity.entries_inheriting, acl_entry.id as ace_id, acl_entry.mask,  acl_entry.granting,  acl_entry.audit_success, acl_entry.audit_failure,  acl_sid.principal as ace_principal, acl_sid.sid as ace_sid,  acli_sid.principal as acl_principal, acli_sid.sid as acl_sid, acl_class.class from acl_object_identity left join acl_sid acli_sid on  acli_sid.id = acl_object_identity.owner_sid left join acl_class on acl_class.id = acl_object_identity.object_id_class   left join acl_entry on acl_object_identity.id = acl_entry.acl_object_identity left join acl_sid on acl_entry.sid = acl_sid.id  where ( ";
        String endSql = ") order by acl_object_identity.object_id_identity asc, acl_entry.ace_order asc";
        StringBuffer sqlStringBuffer = new StringBuffer();
        sqlStringBuffer.append(startSql);
        for (int i = 1; i <= requiredRepetitions; ++i) {
            sqlStringBuffer.append(repeatingSql);
            if (i == requiredRepetitions) continue;
            sqlStringBuffer.append(" or ");
        }
        sqlStringBuffer.append(endSql);
        return sqlStringBuffer.toString();
    }

    private AclImpl convert(Map inputMap, Long currentIdentity) {
        Assert.notEmpty((Map)inputMap, (String)"InputMap required");
        Assert.notNull((Object)currentIdentity, (String)"CurrentIdentity required");
        Acl uncastAcl = (Acl)inputMap.get(currentIdentity);
        Assert.isInstanceOf((Class)(class$org$springframework$security$acls$domain$AclImpl == null ? (class$org$springframework$security$acls$domain$AclImpl = BasicLookupStrategy.class$("org.springframework.security.acls.domain.AclImpl")) : class$org$springframework$security$acls$domain$AclImpl), (Object)uncastAcl, (String)"The inputMap contained a non-AclImpl");
        AclImpl inputAcl = (AclImpl)uncastAcl;
        Acl parent = inputAcl.getParentAcl();
        if (parent != null && parent instanceof StubAclParent) {
            StubAclParent stubAclParent = (StubAclParent)parent;
            parent = this.convert(inputMap, stubAclParent.getId());
        }
        AclImpl result = new AclImpl(inputAcl.getObjectIdentity(), (Long)inputAcl.getId(), this.aclAuthorizationStrategy, this.auditLogger, parent, null, inputAcl.isEntriesInheriting(), inputAcl.getOwner());
        Field field = FieldUtils.getField((Class)(class$org$springframework$security$acls$domain$AclImpl == null ? (class$org$springframework$security$acls$domain$AclImpl = BasicLookupStrategy.class$("org.springframework.security.acls.domain.AclImpl")) : class$org$springframework$security$acls$domain$AclImpl), (String)"aces");
        try {
            ((AccessibleObject)field).setAccessible(true);
            field.set(result, field.get(inputAcl));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Could not obtain or set AclImpl.ace field");
        }
        return result;
    }

    private void convertCurrentResultIntoObject(Map acls, ResultSet rs) throws SQLException {
        Long id = new Long(rs.getLong("acl_id"));
        AclImpl acl = (AclImpl)acls.get(id);
        if (acl == null) {
            ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(rs.getString("class"), (Serializable)new Long(rs.getLong("object_id_identity")));
            StubAclParent parentAcl = null;
            long parentAclId = rs.getLong("parent_object");
            if (parentAclId != 0L) {
                parentAcl = new StubAclParent(new Long(parentAclId));
            }
            boolean entriesInheriting = rs.getBoolean("entries_inheriting");
            Sid owner = rs.getBoolean("acl_principal") ? new PrincipalSid(rs.getString("acl_sid")) : new GrantedAuthoritySid(rs.getString("acl_sid"));
            acl = new AclImpl(objectIdentity, id, this.aclAuthorizationStrategy, this.auditLogger, parentAcl, null, entriesInheriting, owner);
            acls.put(id, acl);
        }
        if (rs.getString("ace_sid") != null) {
            List aces;
            Long aceId = new Long(rs.getLong("ace_id"));
            Sid recipient = rs.getBoolean("ace_principal") ? new PrincipalSid(rs.getString("ace_sid")) : new GrantedAuthoritySid(rs.getString("ace_sid"));
            int mask = rs.getInt("mask");
            Permission permission = this.convertMaskIntoPermission(mask);
            boolean granting = rs.getBoolean("granting");
            boolean auditSuccess = rs.getBoolean("audit_success");
            boolean auditFailure = rs.getBoolean("audit_failure");
            AccessControlEntryImpl ace = new AccessControlEntryImpl(aceId, acl, recipient, permission, granting, auditSuccess, auditFailure);
            Field acesField = FieldUtils.getField((Class)(class$org$springframework$security$acls$domain$AclImpl == null ? (class$org$springframework$security$acls$domain$AclImpl = BasicLookupStrategy.class$("org.springframework.security.acls.domain.AclImpl")) : class$org$springframework$security$acls$domain$AclImpl), (String)"aces");
            try {
                ((AccessibleObject)acesField).setAccessible(true);
                aces = (List)acesField.get(acl);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Could not obtain AclImpl.ace field: cause[" + ex.getMessage() + "]");
            }
            if (!aces.contains(ace)) {
                aces.add(ace);
            }
        }
    }

    protected Permission convertMaskIntoPermission(int mask) {
        return AbstractRegisteredPermission.buildFromMask(mask);
    }

    private Map lookupObjectIdentities(final ObjectIdentity[] objectIdentities, Sid[] sids) {
        Assert.notEmpty((Object[])objectIdentities, (String)"Must provide identities to lookup");
        HashMap acls = new HashMap();
        String sql = BasicLookupStrategy.computeRepeatingSql("(acl_object_identity.object_id_identity = ? and acl_class.class = ?)", objectIdentities.length);
        Set parentsToLookup = (Set)this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                for (int i = 0; i < objectIdentities.length; ++i) {
                    String javaType = objectIdentities[i].getJavaType().getName();
                    String identifier = objectIdentities[i].getIdentifier().toString();
                    long id = Long.valueOf(identifier);
                    ps.setLong(2 * i + 1, id);
                    ps.setString(2 * i + 2, javaType);
                }
            }
        }, (ResultSetExtractor)new ProcessResultSet(acls, sids));
        if (parentsToLookup.size() > 0) {
            this.lookupPrimaryKeys(acls, parentsToLookup, sids);
        }
        HashMap<ObjectIdentity, AclImpl> resultMap = new HashMap<ObjectIdentity, AclImpl>();
        Iterator iter = acls.values().iterator();
        while (iter.hasNext()) {
            Acl inputAcl = (Acl)iter.next();
            Assert.isInstanceOf((Class)(class$org$springframework$security$acls$domain$AclImpl == null ? BasicLookupStrategy.class$("org.springframework.security.acls.domain.AclImpl") : class$org$springframework$security$acls$domain$AclImpl), (Object)inputAcl, (String)"Map should have contained an AclImpl");
            Assert.isInstanceOf((Class)(class$java$lang$Long == null ? BasicLookupStrategy.class$("java.lang.Long") : class$java$lang$Long), (Object)((AclImpl)inputAcl).getId(), (String)"Acl.getId() must be Long");
            AclImpl result = this.convert(acls, (Long)((AclImpl)inputAcl).getId());
            resultMap.put(result.getObjectIdentity(), result);
        }
        return resultMap;
    }

    private void lookupPrimaryKeys(Map acls, final Set findNow, Sid[] sids) {
        Assert.notNull((Object)acls, (String)"ACLs are required");
        Assert.notEmpty((Collection)findNow, (String)"Items to find now required");
        String sql = BasicLookupStrategy.computeRepeatingSql("(acl_object_identity.id = ?)", findNow.size());
        Set parentsToLookup = (Set)this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                Iterator iter = findNow.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    ps.setLong(++i, (Long)iter.next());
                }
            }
        }, (ResultSetExtractor)new ProcessResultSet(acls, sids));
        if (parentsToLookup.size() > 0) {
            this.lookupPrimaryKeys(acls, parentsToLookup, sids);
        }
    }

    public Map readAclsById(ObjectIdentity[] objects, Sid[] sids) {
        Assert.isTrue((this.batchSize >= 1 ? 1 : 0) != 0, (String)"BatchSize must be >= 1");
        Assert.notEmpty((Object[])objects, (String)"Objects to lookup required");
        HashMap<ObjectIdentity, MutableAcl> result = new HashMap<ObjectIdentity, MutableAcl>();
        HashSet<ObjectIdentity> currentBatchToLoad = new HashSet<ObjectIdentity>();
        for (int i = 0; i < objects.length; ++i) {
            MutableAcl acl;
            boolean aclFound = false;
            if (result.containsKey(objects[i])) {
                aclFound = true;
            }
            if (!aclFound && (acl = this.aclCache.getFromCache(objects[i])) != null) {
                if (acl.isSidLoaded(sids)) {
                    result.put(acl.getObjectIdentity(), acl);
                    aclFound = true;
                } else {
                    throw new IllegalStateException("Error: SID-filtered element detected when implementation does not perform SID filtering - have you added something to the cache manually?");
                }
            }
            if (!aclFound) {
                currentBatchToLoad.add(objects[i]);
            }
            if (currentBatchToLoad.size() != this.batchSize && i + 1 != objects.length || currentBatchToLoad.size() <= 0) continue;
            Map loadedBatch = this.lookupObjectIdentities(currentBatchToLoad.toArray(new ObjectIdentity[0]), sids);
            result.putAll(loadedBatch);
            Iterator loadedAclIterator = loadedBatch.values().iterator();
            while (loadedAclIterator.hasNext()) {
                this.aclCache.putInCache((AclImpl)loadedAclIterator.next());
            }
            currentBatchToLoad.clear();
        }
        return result;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StubAclParent
    implements Acl {
        private Long id;

        public StubAclParent(Long id) {
            this.id = id;
        }

        public AccessControlEntry[] getEntries() {
            throw new UnsupportedOperationException("Stub only");
        }

        public Long getId() {
            return this.id;
        }

        public ObjectIdentity getObjectIdentity() {
            throw new UnsupportedOperationException("Stub only");
        }

        public Sid getOwner() {
            throw new UnsupportedOperationException("Stub only");
        }

        public Acl getParentAcl() {
            throw new UnsupportedOperationException("Stub only");
        }

        public boolean isEntriesInheriting() {
            throw new UnsupportedOperationException("Stub only");
        }

        public boolean isGranted(Permission[] permission, Sid[] sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
            throw new UnsupportedOperationException("Stub only");
        }

        public boolean isSidLoaded(Sid[] sids) {
            throw new UnsupportedOperationException("Stub only");
        }
    }

    private class ProcessResultSet
    implements ResultSetExtractor {
        private Map acls;
        private Sid[] sids;

        public ProcessResultSet(Map acls, Sid[] sids) {
            Assert.notNull((Object)acls, (String)"ACLs cannot be null");
            this.acls = acls;
            this.sids = sids;
        }

        public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
            HashSet<Long> parentIdsToLookup = new HashSet<Long>();
            while (rs.next()) {
                BasicLookupStrategy.this.convertCurrentResultIntoObject(this.acls, rs);
                long parentId = rs.getLong("parent_object");
                if (parentId == 0L || this.acls.containsKey(new Long(parentId))) continue;
                MutableAcl cached = BasicLookupStrategy.this.aclCache.getFromCache(new Long(parentId));
                if (cached == null || !cached.isSidLoaded(this.sids)) {
                    parentIdsToLookup.add(new Long(parentId));
                    continue;
                }
                this.acls.put(cached.getId(), cached);
            }
            return parentIdsToLookup;
        }
    }
}

