/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionService;

class AclClassIdUtils {
    private static final String DEFAULT_CLASS_ID_TYPE_COLUMN_NAME = "class_id_type";
    private static final Log log = LogFactory.getLog(AclClassIdUtils.class);
    private ConversionService conversionService;

    Serializable identifierFrom(Serializable identifier, ResultSet resultSet) throws SQLException {
        identifier = this.isString(identifier) && this.hasValidClassIdType(resultSet) && this.canConvertFromStringTo(this.classIdTypeFrom(resultSet)) ? this.convertFromStringTo((String)((Object)identifier), this.classIdTypeFrom(resultSet)) : this.convertToLong(identifier);
        return identifier;
    }

    private boolean hasValidClassIdType(ResultSet resultSet) throws SQLException {
        boolean hasClassIdType = false;
        try {
            hasClassIdType = this.classIdTypeFrom(resultSet) != null;
        }
        catch (SQLException e) {
            log.debug((Object)"Unable to obtain the class id type", (Throwable)e);
        }
        return hasClassIdType;
    }

    private <T extends Serializable> Class<T> classIdTypeFrom(ResultSet resultSet) throws SQLException {
        return this.classIdTypeFrom(resultSet.getString(DEFAULT_CLASS_ID_TYPE_COLUMN_NAME));
    }

    private <T extends Serializable> Class<T> classIdTypeFrom(String className) {
        Class<?> targetType = null;
        if (className != null) {
            try {
                targetType = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)"Unable to find class id type on classpath", (Throwable)e);
            }
        }
        return targetType;
    }

    private <T> boolean canConvertFromStringTo(Class<T> targetType) {
        return this.hasConversionService() && this.conversionService.canConvert(String.class, targetType);
    }

    private <T extends Serializable> T convertFromStringTo(String identifier, Class<T> targetType) {
        return (T)((Serializable)this.conversionService.convert((Object)identifier, targetType));
    }

    private boolean hasConversionService() {
        return this.conversionService != null;
    }

    private Long convertToLong(Serializable identifier) {
        Long idAsLong = this.hasConversionService() ? (Long)this.conversionService.convert((Object)identifier, Long.class) : Long.valueOf(identifier.toString());
        return idAsLong;
    }

    private boolean isString(Serializable object) {
        return object.getClass().isAssignableFrom(String.class);
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

