/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.authentication;

import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.cas.authentication.NullStatelessTicketCache;
import org.springframework.security.cas.authentication.StatelessTicketCache;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
MessageSourceAware {
    private AuthenticationUserDetailsService authenticationUserDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private StatelessTicketCache statelessTicketCache = new NullStatelessTicketCache();
    private String key;
    private TicketValidator ticketValidator;
    private ServiceProperties serviceProperties;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationUserDetailsService, (String)"An authenticationUserDetailsService must be set");
        Assert.notNull((Object)this.ticketValidator, (String)"A ticketValidator must be set");
        Assert.notNull((Object)this.statelessTicketCache, (String)"A statelessTicketCache must be set");
        Assert.hasText((String)this.key, (String)"A Key is required so CasAuthenticationProvider can identify tokens it previously authenticated");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        Assert.notNull((Object)this.serviceProperties, (String)"serviceProperties is a required field.");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (authentication instanceof UsernamePasswordAuthenticationToken && !"_cas_stateful_".equals(authentication.getPrincipal().toString()) && !"_cas_stateless_".equals(authentication.getPrincipal().toString())) {
            return null;
        }
        if (authentication instanceof CasAuthenticationToken) {
            if (this.key.hashCode() == ((CasAuthenticationToken)authentication).getKeyHash()) {
                return authentication;
            }
            throw new BadCredentialsException(this.messages.getMessage("CasAuthenticationProvider.incorrectKey", "The presented CasAuthenticationToken does not contain the expected key"));
        }
        if (authentication.getCredentials() == null || "".equals(authentication.getCredentials())) {
            throw new BadCredentialsException(this.messages.getMessage("CasAuthenticationProvider.noServiceTicket", "Failed to provide a CAS service ticket to validate"));
        }
        boolean stateless = false;
        if (authentication instanceof UsernamePasswordAuthenticationToken && "_cas_stateless_".equals(authentication.getPrincipal())) {
            stateless = true;
        }
        CasAuthenticationToken result = null;
        if (stateless) {
            result = this.statelessTicketCache.getByTicketId(authentication.getCredentials().toString());
        }
        if (result == null) {
            result = this.authenticateNow(authentication);
            result.setDetails(authentication.getDetails());
        }
        if (stateless) {
            this.statelessTicketCache.putTicketInCache(result);
        }
        return result;
    }

    private CasAuthenticationToken authenticateNow(Authentication authentication) throws AuthenticationException {
        try {
            Assertion assertion = this.ticketValidator.validate(authentication.getCredentials().toString(), this.serviceProperties.getService());
            UserDetails userDetails = this.loadUserByAssertion(assertion);
            this.userDetailsChecker.check(userDetails);
            return new CasAuthenticationToken(this.key, userDetails, authentication.getCredentials(), userDetails.getAuthorities(), userDetails, assertion);
        }
        catch (TicketValidationException e) {
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    protected UserDetails loadUserByAssertion(Assertion assertion) {
        CasAssertionAuthenticationToken token = new CasAssertionAuthenticationToken(assertion, "");
        return this.authenticationUserDetailsService.loadUserDetails((Authentication)token);
    }

    @Deprecated
    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.authenticationUserDetailsService = new UserDetailsByNameServiceWrapper(userDetailsService);
    }

    public void setAuthenticationUserDetailsService(AuthenticationUserDetailsService authenticationUserDetailsService) {
        this.authenticationUserDetailsService = authenticationUserDetailsService;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    protected String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public StatelessTicketCache getStatelessTicketCache() {
        return this.statelessTicketCache;
    }

    protected TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setStatelessTicketCache(StatelessTicketCache statelessTicketCache) {
        this.statelessTicketCache = statelessTicketCache;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public boolean supports(Class<? extends Object> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication) || CasAuthenticationToken.class.isAssignableFrom(authentication) || CasAssertionAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

