/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.web;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.util.CommonUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class CasAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String CAS_STATEFUL_IDENTIFIER = "_cas_stateful_";
    public static final String CAS_STATELESS_IDENTIFIER = "_cas_stateless_";
    private String proxyReceptorUrl;
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage;
    private String artifactParameter = "ticket";

    public CasAuthenticationFilter() {
        super("/j_spring_cas_security_check");
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        if (this.isProxyRequest(request)) {
            CommonUtils.readAndRespondToProxyReceptorRequest((HttpServletRequest)request, (HttpServletResponse)response, (ProxyGrantingTicketStorage)this.proxyGrantingTicketStorage);
            return null;
        }
        String username = CAS_STATEFUL_IDENTIFIER;
        String password = request.getParameter(this.artifactParameter);
        if (password == null) {
            password = "";
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)CAS_STATEFUL_IDENTIFIER, (Object)password);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return this.isProxyRequest(request) || super.requiresAuthentication(request, response);
    }

    public final void setProxyReceptorUrl(String proxyReceptorUrl) {
        this.proxyReceptorUrl = proxyReceptorUrl;
    }

    public final void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage proxyGrantingTicketStorage) {
        this.proxyGrantingTicketStorage = proxyGrantingTicketStorage;
    }

    public final void setServiceProperties(ServiceProperties serviceProperties) {
        this.artifactParameter = serviceProperties.getArtifactParameter();
    }

    private boolean isProxyRequest(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        return this.proxyGrantingTicketStorage != null && !CommonUtils.isEmpty((String)this.proxyReceptorUrl) && requestUri.endsWith(this.proxyReceptorUrl);
    }
}

