/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.adapters.catalina;

import java.io.File;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.RealmBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.adapters.PrincipalSpringSecurityUserToken;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class CatalinaSpringSecurityUserRealm
extends RealmBase {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$adapters$catalina$CatalinaSpringSecurityUserRealm == null ? (class$org$springframework$security$adapters$catalina$CatalinaSpringSecurityUserRealm = CatalinaSpringSecurityUserRealm.class$("org.springframework.security.adapters.catalina.CatalinaSpringSecurityUserRealm")) : class$org$springframework$security$adapters$catalina$CatalinaSpringSecurityUserRealm));
    private AuthenticationManager authenticationManager;
    private Container container;
    private String appContextLocation;
    private String key;
    protected final String name = "CatalinaSpringUserRealm / $Id:CatalinaSpringSecurityUserRealm.java 2151 2007-09-22 11:54:13Z luke_t $";
    static /* synthetic */ Class class$org$springframework$security$adapters$catalina$CatalinaSpringSecurityUserRealm;
    static /* synthetic */ Class class$org$springframework$security$AuthenticationManager;

    public Principal authenticate(String username, String credentials) {
        if (username == null) {
            return null;
        }
        if (credentials == null) {
            credentials = "";
        }
        UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken((Object)username, (Object)credentials);
        Authentication response = null;
        try {
            response = this.authenticationManager.authenticate((Authentication)request);
        }
        catch (AuthenticationException failed) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication request for user: " + username + " failed: " + failed.toString()));
            }
            return null;
        }
        return new PrincipalSpringSecurityUserToken(this.key, response.getPrincipal().toString(), response.getCredentials().toString(), response.getAuthorities(), response.getPrincipal());
    }

    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, new String(credentials));
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        return null;
    }

    public Principal authenticate(X509Certificate[] x509Certificates) {
        return null;
    }

    public String getAppContextLocation() {
        return this.appContextLocation;
    }

    public String getKey() {
        return this.key;
    }

    protected String getName() {
        return this.name;
    }

    protected String getPassword(String arg0) {
        return null;
    }

    protected Principal getPrincipal(String arg0) {
        return null;
    }

    public boolean hasRole(Principal principal, String role) {
        if (principal == null || role == null) {
            return false;
        }
        if (!(principal instanceof PrincipalSpringSecurityUserToken)) {
            logger.warn((Object)("Expected passed principal to be of type PrincipalSpringSecurityUserToken but was " + principal.getClass().getName()));
            return false;
        }
        PrincipalSpringSecurityUserToken test = (PrincipalSpringSecurityUserToken)principal;
        return test.isUserInRole(role);
    }

    public void setAppContextLocation(String appContextLocation) {
        this.appContextLocation = appContextLocation;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void start() throws LifecycleException {
        this.start(true);
    }

    private void start(boolean startParent) throws LifecycleException {
        if (startParent) {
            super.start();
        }
        if (this.appContextLocation == null || "".equals(this.appContextLocation)) {
            throw new LifecycleException("appContextLocation must be defined");
        }
        if (this.key == null || "".equals(this.key)) {
            throw new LifecycleException("key must be defined");
        }
        File xml = new File(System.getProperty("catalina.base"), this.appContextLocation);
        if (!xml.exists()) {
            throw new LifecycleException("appContextLocation does not seem to exist in " + xml.toString());
        }
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext("file:" + xml.getAbsolutePath());
        Map beans = ctx.getBeansOfType(class$org$springframework$security$AuthenticationManager == null ? (class$org$springframework$security$AuthenticationManager = CatalinaSpringSecurityUserRealm.class$("org.springframework.security.AuthenticationManager")) : class$org$springframework$security$AuthenticationManager, true, true);
        if (beans.size() == 0) {
            throw new IllegalArgumentException("Bean context must contain at least one bean of type AuthenticationManager");
        }
        String beanName = (String)beans.keySet().iterator().next();
        this.authenticationManager = (AuthenticationManager)beans.get(beanName);
        logger.info((Object)"CatalinaSpringSecurityUserRealm Started");
    }

    protected void startForTest() throws LifecycleException {
        this.start(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

