/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.OrderComparator;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.authentication.AuthenticationManagerFactoryBean;
import org.springframework.security.config.http.AuthenticationConfigBuilder;
import org.springframework.security.config.http.HttpConfigurationBuilder;
import org.springframework.security.config.http.OrderDecorator;
import org.springframework.security.config.http.PortMappingsBeanDefinitionParser;
import org.springframework.security.config.http.SecurityFilters;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.savedrequest.RequestCacheAwareFilter;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.RegexUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Log logger = LogFactory.getLog(HttpSecurityBeanDefinitionParser.class);
    static final String ATT_PATH_PATTERN = "pattern";
    static final String ATT_PATH_TYPE = "path-type";
    static final String OPT_PATH_TYPE_REGEX = "regex";
    private static final String DEF_PATH_TYPE_ANT = "ant";
    static final String ATT_FILTERS = "filters";
    static final String OPT_FILTERS_NONE = "none";
    static final String ATT_REQUIRES_CHANNEL = "requires-channel";
    private static final String ATT_LOWERCASE_COMPARISONS = "lowercase-comparisons";
    private static final String ATT_REF = "ref";
    static final String EXPRESSION_FIMDS_CLASS = "org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource";
    static final String EXPRESSION_HANDLER_CLASS = "org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler";
    static final List<BeanMetadataElement> NO_FILTERS = Collections.emptyList();

    public BeanDefinition parse(Element element, ParserContext pc) {
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), pc.extractSource((Object)element));
        pc.pushContainingComponent(compositeDef);
        Object source = pc.extractSource((Object)element);
        String portMapperName = this.createPortMapper(element, pc);
        UrlMatcher matcher = HttpSecurityBeanDefinitionParser.createUrlMatcher(element);
        HttpConfigurationBuilder httpBldr = new HttpConfigurationBuilder(element, pc, matcher, portMapperName);
        httpBldr.parseInterceptUrlsForEmptyFilterChains();
        httpBldr.createSecurityContextPersistenceFilter();
        httpBldr.createSessionManagementFilters();
        ManagedList authenticationProviders = new ManagedList();
        BeanReference authenticationManager = this.createAuthenticationManager(element, pc, (ManagedList<BeanReference>)authenticationProviders, null);
        httpBldr.createServletApiFilter();
        httpBldr.createChannelProcessingFilter();
        httpBldr.createFilterSecurityInterceptor(authenticationManager);
        AuthenticationConfigBuilder authBldr = new AuthenticationConfigBuilder(element, pc, httpBldr.isAllowSessionCreation(), portMapperName);
        authBldr.createAnonymousFilter();
        authBldr.createRememberMeFilter(authenticationManager);
        authBldr.createRequestCache();
        authBldr.createBasicFilter(authenticationManager);
        authBldr.createFormLoginFilter(httpBldr.getSessionStrategy(), authenticationManager);
        authBldr.createOpenIDLoginFilter(httpBldr.getSessionStrategy(), authenticationManager);
        authBldr.createX509Filter(authenticationManager);
        authBldr.createLogoutFilter();
        authBldr.createLoginPageFilterIfNeeded();
        authBldr.createUserServiceInjector();
        authBldr.createExceptionTranslationFilter();
        ArrayList<OrderDecorator> unorderedFilterChain = new ArrayList<OrderDecorator>();
        unorderedFilterChain.addAll(httpBldr.getFilters());
        unorderedFilterChain.addAll(authBldr.getFilters());
        authenticationProviders.addAll(authBldr.getProviders());
        RootBeanDefinition requestCacheAwareFilter = new RootBeanDefinition(RequestCacheAwareFilter.class);
        requestCacheAwareFilter.getPropertyValues().addPropertyValue("requestCache", (Object)authBldr.getRequestCache());
        unorderedFilterChain.add(new OrderDecorator((BeanMetadataElement)requestCacheAwareFilter, SecurityFilters.REQUEST_CACHE_FILTER));
        unorderedFilterChain.addAll(this.buildCustomFilterList(element, pc));
        Collections.sort(unorderedFilterChain, new OrderComparator());
        this.checkFilterChainOrder(unorderedFilterChain, pc, source);
        ManagedList filterChain = new ManagedList();
        for (OrderDecorator od : unorderedFilterChain) {
            filterChain.add(od.bean);
        }
        ManagedMap<BeanDefinition, List<BeanMetadataElement>> filterChainMap = httpBldr.getFilterChainMap();
        RootBeanDefinition universalMatch = new RootBeanDefinition(String.class);
        universalMatch.getConstructorArgumentValues().addGenericArgumentValue((Object)matcher.getUniversalMatchPattern());
        filterChainMap.put((Object)universalMatch, (Object)filterChain);
        this.registerFilterChainProxy(pc, (Map<BeanDefinition, List<BeanMetadataElement>>)filterChainMap, matcher, source);
        pc.popAndRegisterContainingComponent();
        return null;
    }

    private String createPortMapper(Element elt, ParserContext pc) {
        BeanDefinition portMapper = new PortMappingsBeanDefinitionParser().parse(DomUtils.getChildElementByTagName((Element)elt, (String)"port-mappings"), pc);
        String portMapperName = pc.getReaderContext().generateBeanName(portMapper);
        pc.registerBeanComponent(new BeanComponentDefinition(portMapper, portMapperName));
        return portMapperName;
    }

    private BeanReference createAuthenticationManager(Element element, ParserContext pc, ManagedList<BeanReference> authenticationProviders, BeanReference concurrencyController) {
        BeanDefinitionBuilder authManager = BeanDefinitionBuilder.rootBeanDefinition(ProviderManager.class);
        authManager.addPropertyValue("parent", (Object)new RootBeanDefinition(AuthenticationManagerFactoryBean.class));
        authManager.addPropertyValue("providers", authenticationProviders);
        if (concurrencyController != null) {
            authManager.addPropertyValue("sessionController", (Object)concurrencyController);
        }
        authManager.getRawBeanDefinition().setSource(pc.extractSource((Object)element));
        AbstractBeanDefinition authMgrBean = authManager.getBeanDefinition();
        String id = pc.getReaderContext().generateBeanName((BeanDefinition)authMgrBean);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)authMgrBean, id));
        return new RuntimeBeanReference(id);
    }

    private void checkFilterChainOrder(List<OrderDecorator> filters, ParserContext pc, Object source) {
        logger.info((Object)("Checking sorted filter chain: " + filters));
        for (int i = 0; i < filters.size(); ++i) {
            OrderDecorator filter = filters.get(i);
            if (i <= 0) continue;
            OrderDecorator previous = filters.get(i - 1);
            if (filter.getOrder() != previous.getOrder()) continue;
            pc.getReaderContext().error("Filter beans '" + filter.bean + "' and '" + previous.bean + "' have the same 'order' value. When using custom filters, " + "please make sure the positions do not conflict with default filters. " + "Alternatively you can disable the default filters by removing the corresponding " + "child elements from <http> and avoiding the use of <http auto-config='true'>.", source);
        }
    }

    List<OrderDecorator> buildCustomFilterList(Element element, ParserContext pc) {
        List customFilterElts = DomUtils.getChildElementsByTagName((Element)element, (String)"custom-filter");
        ArrayList<OrderDecorator> customFilters = new ArrayList<OrderDecorator>();
        String ATT_AFTER = "after";
        String ATT_BEFORE = "before";
        String ATT_POSITION = "position";
        for (Element elt : customFilterElts) {
            SecurityFilters order;
            String after = elt.getAttribute("after");
            String before = elt.getAttribute("before");
            String position = elt.getAttribute("position");
            String ref = elt.getAttribute(ATT_REF);
            if (!StringUtils.hasText((String)ref)) {
                pc.getReaderContext().error("The 'ref' attribute must be supplied", pc.extractSource((Object)elt));
            }
            RuntimeBeanReference bean = new RuntimeBeanReference(ref);
            if (WebConfigUtils.countNonEmpty(new String[]{after, before, position}) != 1) {
                pc.getReaderContext().error("A single 'after', 'before', or 'position' attribute must be supplied", pc.extractSource((Object)elt));
            }
            if (StringUtils.hasText((String)position)) {
                customFilters.add(new OrderDecorator((BeanMetadataElement)bean, SecurityFilters.valueOf(position)));
                continue;
            }
            if (StringUtils.hasText((String)after)) {
                order = SecurityFilters.valueOf(after);
                if (order == SecurityFilters.LAST) {
                    customFilters.add(new OrderDecorator((BeanMetadataElement)bean, SecurityFilters.LAST));
                    continue;
                }
                customFilters.add(new OrderDecorator((BeanMetadataElement)bean, order.getOrder() + 1));
                continue;
            }
            if (!StringUtils.hasText((String)before)) continue;
            order = SecurityFilters.valueOf(before);
            if (order == SecurityFilters.FIRST) {
                customFilters.add(new OrderDecorator((BeanMetadataElement)bean, SecurityFilters.FIRST));
                continue;
            }
            customFilters.add(new OrderDecorator((BeanMetadataElement)bean, order.getOrder() - 1));
        }
        return customFilters;
    }

    private void registerFilterChainProxy(ParserContext pc, Map<BeanDefinition, List<BeanMetadataElement>> filterChainMap, UrlMatcher matcher, Object source) {
        if (pc.getRegistry().containsBeanDefinition("org.springframework.security.filterChainProxy")) {
            pc.getReaderContext().error("Duplicate <http> element detected", source);
        }
        BeanDefinitionBuilder fcpBldr = BeanDefinitionBuilder.rootBeanDefinition(FilterChainProxy.class);
        fcpBldr.getRawBeanDefinition().setSource(source);
        fcpBldr.addPropertyValue("matcher", (Object)matcher);
        fcpBldr.addPropertyValue("stripQueryStringFromUrls", (Object)(matcher instanceof AntUrlPathMatcher));
        fcpBldr.addPropertyValue("filterChainMap", filterChainMap);
        AbstractBeanDefinition fcpBean = fcpBldr.getBeanDefinition();
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)fcpBean, "org.springframework.security.filterChainProxy"));
        pc.getRegistry().registerAlias("org.springframework.security.filterChainProxy", "springSecurityFilterChain");
    }

    static UrlMatcher createUrlMatcher(Element element) {
        String lowercaseComparisons;
        String patternType = element.getAttribute(ATT_PATH_TYPE);
        if (!StringUtils.hasText((String)patternType)) {
            patternType = DEF_PATH_TYPE_ANT;
        }
        boolean useRegex = patternType.equals(OPT_PATH_TYPE_REGEX);
        AntUrlPathMatcher matcher = new AntUrlPathMatcher();
        if (useRegex) {
            matcher = new RegexUrlPathMatcher();
        }
        if (!StringUtils.hasText((String)(lowercaseComparisons = element.getAttribute(ATT_LOWERCASE_COMPARISONS)))) {
            lowercaseComparisons = null;
        }
        if ("true".equals(lowercaseComparisons)) {
            if (useRegex) {
                ((RegexUrlPathMatcher)matcher).setRequiresLowerCaseUrl(true);
            }
        } else if ("false".equals(lowercaseComparisons) && !useRegex) {
            matcher.setRequiresLowerCaseUrl(false);
        }
        return matcher;
    }
}

