/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.header.HeaderWriterFilter;
import org.springframework.security.web.header.writers.CacheControlHeadersWriter;
import org.springframework.security.web.header.writers.HstsHeaderWriter;
import org.springframework.security.web.header.writers.StaticHeadersWriter;
import org.springframework.security.web.header.writers.XContentTypeOptionsHeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;
import org.springframework.security.web.header.writers.frameoptions.RegExpAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.StaticAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.WhiteListedAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.XFrameOptionsHeaderWriter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HeadersBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATT_DISABLED = "disabled";
    private static final String ATT_ENABLED = "enabled";
    private static final String ATT_BLOCK = "block";
    private static final String ATT_POLICY = "policy";
    private static final String ATT_STRATEGY = "strategy";
    private static final String ATT_FROM_PARAMETER = "from-parameter";
    private static final String ATT_NAME = "name";
    private static final String ATT_VALUE = "value";
    private static final String ATT_REF = "ref";
    private static final String ATT_INCLUDE_SUBDOMAINS = "include-subdomains";
    private static final String ATT_MAX_AGE_SECONDS = "max-age-seconds";
    private static final String ATT_REQUEST_MATCHER_REF = "request-matcher-ref";
    private static final String CACHE_CONTROL_ELEMENT = "cache-control";
    private static final String HSTS_ELEMENT = "hsts";
    private static final String XSS_ELEMENT = "xss-protection";
    private static final String CONTENT_TYPE_ELEMENT = "content-type-options";
    private static final String FRAME_OPTIONS_ELEMENT = "frame-options";
    private static final String GENERIC_HEADER_ELEMENT = "header";
    private static final String ALLOW_FROM = "ALLOW-FROM";
    private ManagedList<BeanMetadataElement> headerWriters;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.headerWriters = new ManagedList();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(HeaderWriterFilter.class);
        boolean disabled = element != null && "true".equals(element.getAttribute(ATT_DISABLED));
        boolean defaultsDisabled = element != null && "true".equals(element.getAttribute("defaults-disabled"));
        boolean addIfNotPresent = element == null || !disabled && !defaultsDisabled;
        this.parseCacheControlElement(addIfNotPresent, element);
        this.parseHstsElement(addIfNotPresent, element, parserContext);
        this.parseXssElement(addIfNotPresent, element, parserContext);
        this.parseFrameOptionsElement(addIfNotPresent, element, parserContext);
        this.parseContentTypeOptionsElement(addIfNotPresent, element);
        this.parseHeaderElements(element);
        if (disabled) {
            if (!this.headerWriters.isEmpty()) {
                parserContext.getReaderContext().error("Cannot specify <headers disabled=\"true\"> with child elements.", (Object)element);
            }
            return null;
        }
        builder.addConstructorArgValue(this.headerWriters);
        return builder.getBeanDefinition();
    }

    private void parseCacheControlElement(boolean addIfNotPresent, Element element) {
        Element cacheControlElement = element == null ? null : DomUtils.getChildElementByTagName((Element)element, (String)CACHE_CONTROL_ELEMENT);
        boolean disabled = "true".equals(this.getAttribute(cacheControlElement, ATT_DISABLED, "false"));
        if (disabled) {
            return;
        }
        if (addIfNotPresent || cacheControlElement != null) {
            this.addCacheControl();
        }
    }

    private void addCacheControl() {
        BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(CacheControlHeadersWriter.class);
        this.headerWriters.add((Object)headersWriter.getBeanDefinition());
    }

    private void parseHstsElement(boolean addIfNotPresent, Element element, ParserContext context) {
        Element hstsElement;
        Element element2 = hstsElement = element == null ? null : DomUtils.getChildElementByTagName((Element)element, (String)HSTS_ELEMENT);
        if (addIfNotPresent || hstsElement != null) {
            this.addHsts(addIfNotPresent, hstsElement, context);
        }
    }

    private void addHsts(boolean addIfNotPresent, Element hstsElement, ParserContext context) {
        BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(HstsHeaderWriter.class);
        if (hstsElement != null) {
            String requestMatcherRef;
            String maxAgeSeconds;
            boolean disabled = "true".equals(this.getAttribute(hstsElement, ATT_DISABLED, "false"));
            String includeSubDomains = hstsElement.getAttribute(ATT_INCLUDE_SUBDOMAINS);
            if (StringUtils.hasText((String)includeSubDomains)) {
                if (disabled) {
                    this.attrNotAllowed(context, ATT_INCLUDE_SUBDOMAINS, ATT_DISABLED, hstsElement);
                }
                headersWriter.addPropertyValue("includeSubDomains", (Object)includeSubDomains);
            }
            if (StringUtils.hasText((String)(maxAgeSeconds = hstsElement.getAttribute(ATT_MAX_AGE_SECONDS)))) {
                if (disabled) {
                    this.attrNotAllowed(context, ATT_MAX_AGE_SECONDS, ATT_DISABLED, hstsElement);
                }
                headersWriter.addPropertyValue("maxAgeInSeconds", (Object)maxAgeSeconds);
            }
            if (StringUtils.hasText((String)(requestMatcherRef = hstsElement.getAttribute(ATT_REQUEST_MATCHER_REF)))) {
                if (disabled) {
                    this.attrNotAllowed(context, ATT_REQUEST_MATCHER_REF, ATT_DISABLED, hstsElement);
                }
                headersWriter.addPropertyReference("requestMatcher", requestMatcherRef);
            }
            if (disabled) {
                return;
            }
        }
        if (addIfNotPresent || hstsElement != null) {
            this.headerWriters.add((Object)headersWriter.getBeanDefinition());
        }
    }

    private void attrNotAllowed(ParserContext context, String attrName, String otherAttrName, Element element) {
        context.getReaderContext().error("Only one of '" + attrName + "' or '" + otherAttrName + "' can be set.", (Object)element);
    }

    private void parseHeaderElements(Element element) {
        List headerElts = element == null ? Collections.emptyList() : DomUtils.getChildElementsByTagName((Element)element, (String)GENERIC_HEADER_ELEMENT);
        for (Element headerElt : headerElts) {
            String headerFactoryRef = headerElt.getAttribute(ATT_REF);
            if (StringUtils.hasText((String)headerFactoryRef)) {
                this.headerWriters.add((Object)new RuntimeBeanReference(headerFactoryRef));
                continue;
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticHeadersWriter.class);
            builder.addConstructorArgValue((Object)headerElt.getAttribute(ATT_NAME));
            builder.addConstructorArgValue((Object)headerElt.getAttribute(ATT_VALUE));
            this.headerWriters.add((Object)builder.getBeanDefinition());
        }
    }

    private void parseContentTypeOptionsElement(boolean addIfNotPresent, Element element) {
        Element contentTypeElt = element == null ? null : DomUtils.getChildElementByTagName((Element)element, (String)CONTENT_TYPE_ELEMENT);
        boolean disabled = "true".equals(this.getAttribute(contentTypeElt, ATT_DISABLED, "false"));
        if (disabled) {
            return;
        }
        if (addIfNotPresent || contentTypeElt != null) {
            this.addContentTypeOptions();
        }
    }

    private void addContentTypeOptions() {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XContentTypeOptionsHeaderWriter.class);
        this.headerWriters.add((Object)builder.getBeanDefinition());
    }

    private void parseFrameOptionsElement(boolean addIfNotPresent, Element element, ParserContext parserContext) {
        Element frameElt;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XFrameOptionsHeaderWriter.class);
        Element element2 = frameElt = element == null ? null : DomUtils.getChildElementByTagName((Element)element, (String)FRAME_OPTIONS_ELEMENT);
        if (frameElt != null) {
            String header = this.getAttribute(frameElt, ATT_POLICY, null);
            boolean disabled = "true".equals(this.getAttribute(frameElt, ATT_DISABLED, "false"));
            if (disabled && header != null) {
                this.attrNotAllowed(parserContext, ATT_DISABLED, ATT_POLICY, frameElt);
            }
            if (!StringUtils.hasText((String)header)) {
                header = "DENY";
            }
            if (ALLOW_FROM.equals(header)) {
                String strategyRef = this.getAttribute(frameElt, ATT_REF, null);
                String strategy = this.getAttribute(frameElt, ATT_STRATEGY, null);
                if (StringUtils.hasText((String)strategy) && StringUtils.hasText((String)strategyRef)) {
                    parserContext.getReaderContext().error("Only one of 'strategy' or 'strategy-ref' can be set.", (Object)frameElt);
                } else if (strategyRef != null) {
                    builder.addConstructorArgReference(strategyRef);
                } else if (strategy != null) {
                    String value = this.getAttribute(frameElt, ATT_VALUE, null);
                    if (!StringUtils.hasText((String)value)) {
                        parserContext.getReaderContext().error("Strategy requires a 'value' to be set.", (Object)frameElt);
                    }
                    if ("static".equals(strategy)) {
                        try {
                            builder.addConstructorArgValue((Object)new StaticAllowFromStrategy(new URI(value)));
                        }
                        catch (URISyntaxException e) {
                            parserContext.getReaderContext().error("'value' attribute doesn't represent a valid URI.", (Object)frameElt, (Throwable)e);
                        }
                    } else {
                        BeanDefinitionBuilder allowFromStrategy;
                        if ("whitelist".equals(strategy)) {
                            allowFromStrategy = BeanDefinitionBuilder.rootBeanDefinition(WhiteListedAllowFromStrategy.class);
                            allowFromStrategy.addConstructorArgValue((Object)StringUtils.commaDelimitedListToSet((String)value));
                        } else {
                            allowFromStrategy = BeanDefinitionBuilder.rootBeanDefinition(RegExpAllowFromStrategy.class);
                            allowFromStrategy.addConstructorArgValue((Object)value);
                        }
                        String fromParameter = this.getAttribute(frameElt, ATT_FROM_PARAMETER, "from");
                        allowFromStrategy.addPropertyValue("allowFromParameterName", (Object)fromParameter);
                        builder.addConstructorArgValue((Object)allowFromStrategy.getBeanDefinition());
                    }
                } else {
                    parserContext.getReaderContext().error("One of 'strategy' and 'strategy-ref' must be set.", (Object)frameElt);
                }
            } else {
                builder.addConstructorArgValue((Object)header);
            }
            if (disabled) {
                return;
            }
        }
        if (addIfNotPresent || frameElt != null) {
            this.headerWriters.add((Object)builder.getBeanDefinition());
        }
    }

    private void parseXssElement(boolean addIfNotPresent, Element element, ParserContext parserContext) {
        Element xssElt = element == null ? null : DomUtils.getChildElementByTagName((Element)element, (String)XSS_ELEMENT);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XXssProtectionHeaderWriter.class);
        if (xssElt != null) {
            String block;
            boolean disabled = "true".equals(this.getAttribute(xssElt, ATT_DISABLED, "false"));
            String enabled = xssElt.getAttribute(ATT_ENABLED);
            if (StringUtils.hasText((String)enabled)) {
                if (disabled) {
                    this.attrNotAllowed(parserContext, ATT_ENABLED, ATT_DISABLED, xssElt);
                }
                builder.addPropertyValue(ATT_ENABLED, (Object)enabled);
            }
            if (StringUtils.hasText((String)(block = xssElt.getAttribute(ATT_BLOCK)))) {
                if (disabled) {
                    this.attrNotAllowed(parserContext, ATT_BLOCK, ATT_DISABLED, xssElt);
                }
                builder.addPropertyValue(ATT_BLOCK, (Object)block);
            }
            if (disabled) {
                return;
            }
        }
        if (addIfNotPresent || xssElt != null) {
            this.headerWriters.add((Object)builder.getBeanDefinition());
        }
    }

    private String getAttribute(Element element, String name, String defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String value = element.getAttribute(name);
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        return defaultValue;
    }
}

