/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.DebugBeanDefinitionParser;
import org.springframework.security.config.authentication.AuthenticationManagerBeanDefinitionParser;
import org.springframework.security.config.authentication.AuthenticationProviderBeanDefinitionParser;
import org.springframework.security.config.authentication.JdbcUserServiceBeanDefinitionParser;
import org.springframework.security.config.authentication.UserServiceBeanDefinitionParser;
import org.springframework.security.config.http.FilterChainBeanDefinitionParser;
import org.springframework.security.config.http.FilterChainMapBeanDefinitionDecorator;
import org.springframework.security.config.http.FilterInvocationSecurityMetadataSourceParser;
import org.springframework.security.config.http.HttpFirewallBeanDefinitionParser;
import org.springframework.security.config.http.HttpSecurityBeanDefinitionParser;
import org.springframework.security.config.ldap.LdapProviderBeanDefinitionParser;
import org.springframework.security.config.ldap.LdapServerBeanDefinitionParser;
import org.springframework.security.config.ldap.LdapUserServiceBeanDefinitionParser;
import org.springframework.security.config.method.GlobalMethodSecurityBeanDefinitionParser;
import org.springframework.security.config.method.InterceptMethodsBeanDefinitionDecorator;
import org.springframework.security.config.method.MethodSecurityMetadataSourceBeanDefinitionParser;
import org.springframework.security.config.websocket.WebSocketMessageBrokerSecurityBeanDefinitionParser;
import org.springframework.security.core.SpringSecurityCoreVersion;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SecurityNamespaceHandler
implements NamespaceHandler {
    private static final String FILTER_CHAIN_PROXY_CLASSNAME = "org.springframework.security.web.FilterChainProxy";
    private static final String MESSAGE_CLASSNAME = "org.springframework.messaging.Message";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, BeanDefinitionParser> parsers = new HashMap<String, BeanDefinitionParser>();
    private final BeanDefinitionDecorator interceptMethodsBDD = new InterceptMethodsBeanDefinitionDecorator();
    private BeanDefinitionDecorator filterChainMapBDD;

    public SecurityNamespaceHandler() {
        String coreVersion = SpringSecurityCoreVersion.getVersion();
        Package pkg = SpringSecurityCoreVersion.class.getPackage();
        if (pkg == null || coreVersion == null) {
            this.logger.info((Object)"Couldn't determine package version information.");
            return;
        }
        String version = pkg.getImplementationVersion();
        this.logger.info((Object)("Spring Security 'config' module version is " + version));
        if (version.compareTo(coreVersion) != 0) {
            this.logger.error((Object)"You are running with different versions of the Spring Security 'core' and 'config' modules");
        }
    }

    public BeanDefinition parse(Element element, ParserContext pc) {
        String name;
        BeanDefinitionParser parser;
        if (!this.namespaceMatchesVersion(element)) {
            pc.getReaderContext().fatal("You cannot use a spring-security-2.0.xsd or spring-security-3.0.xsd or spring-security-3.1.xsd schema or spring-security-3.2.xsd schema or spring-security-4.0.xsd schema with Spring Security 4.2. Please update your schema declarations to the 4.2 schema.", (Object)element);
        }
        if ((parser = this.parsers.get(name = pc.getDelegate().getLocalName((Node)element))) == null) {
            this.loadParsers();
        }
        if (parser == null) {
            if ("http".equals(name) || "filter-security-metadata-source".equals(name) || "filter-chain-map".equals(name) || "filter-chain".equals(name)) {
                this.reportMissingWebClasses(name, pc, element);
            } else {
                this.reportUnsupportedNodeType(name, pc, element);
            }
            return null;
        }
        return parser.parse(element, pc);
    }

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext pc) {
        String name = pc.getDelegate().getLocalName(node);
        if (node instanceof Element) {
            if ("intercept-methods".equals(name)) {
                return this.interceptMethodsBDD.decorate(node, definition, pc);
            }
            if ("filter-chain-map".equals(name)) {
                if (this.filterChainMapBDD == null) {
                    this.loadParsers();
                }
                if (this.filterChainMapBDD == null) {
                    this.reportMissingWebClasses(name, pc, node);
                }
                return this.filterChainMapBDD.decorate(node, definition, pc);
            }
        }
        this.reportUnsupportedNodeType(name, pc, node);
        return null;
    }

    private void reportUnsupportedNodeType(String name, ParserContext pc, Node node) {
        pc.getReaderContext().fatal("Security namespace does not support decoration of " + (node instanceof Element ? "element" : "attribute") + " [" + name + "]", (Object)node);
    }

    private void reportMissingWebClasses(String nodeName, ParserContext pc, Node node) {
        String errorMessage = "The classes from the spring-security-web jar (or one of its dependencies) are not available. You need these to use <" + nodeName + ">";
        try {
            ClassUtils.forName((String)FILTER_CHAIN_PROXY_CLASSNAME, (ClassLoader)this.getClass().getClassLoader());
            pc.getReaderContext().fatal(errorMessage, (Object)node);
        }
        catch (Throwable cause) {
            pc.getReaderContext().fatal(errorMessage, (Object)node, cause);
        }
    }

    public void init() {
        this.loadParsers();
    }

    private void loadParsers() {
        this.parsers.put("ldap-authentication-provider", new LdapProviderBeanDefinitionParser());
        this.parsers.put("ldap-server", new LdapServerBeanDefinitionParser());
        this.parsers.put("ldap-user-service", new LdapUserServiceBeanDefinitionParser());
        this.parsers.put("user-service", new UserServiceBeanDefinitionParser());
        this.parsers.put("jdbc-user-service", new JdbcUserServiceBeanDefinitionParser());
        this.parsers.put("authentication-provider", new AuthenticationProviderBeanDefinitionParser());
        this.parsers.put("global-method-security", new GlobalMethodSecurityBeanDefinitionParser());
        this.parsers.put("authentication-manager", new AuthenticationManagerBeanDefinitionParser());
        this.parsers.put("method-security-metadata-source", (BeanDefinitionParser)new MethodSecurityMetadataSourceBeanDefinitionParser());
        if (ClassUtils.isPresent((String)FILTER_CHAIN_PROXY_CLASSNAME, (ClassLoader)this.getClass().getClassLoader())) {
            this.parsers.put("debug", new DebugBeanDefinitionParser());
            this.parsers.put("http", new HttpSecurityBeanDefinitionParser());
            this.parsers.put("http-firewall", new HttpFirewallBeanDefinitionParser());
            this.parsers.put("filter-security-metadata-source", new FilterInvocationSecurityMetadataSourceParser());
            this.parsers.put("filter-chain", new FilterChainBeanDefinitionParser());
            this.filterChainMapBDD = new FilterChainMapBeanDefinitionDecorator();
        }
        if (ClassUtils.isPresent((String)MESSAGE_CLASSNAME, (ClassLoader)this.getClass().getClassLoader())) {
            this.parsers.put("websocket-message-broker", new WebSocketMessageBrokerSecurityBeanDefinitionParser());
        }
    }

    private boolean namespaceMatchesVersion(Element element) {
        return this.matchesVersionInternal(element) && this.matchesVersionInternal(element.getOwnerDocument().getDocumentElement());
    }

    private boolean matchesVersionInternal(Element element) {
        String schemaLocation = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        return schemaLocation.matches("(?m).*spring-security-4\\.2.*.xsd.*") || schemaLocation.matches("(?m).*spring-security.xsd.*") || !schemaLocation.matches("(?m).*spring-security.*");
    }
}

