/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractConfigAttributeRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

final class PermitAllSupport {
    private PermitAllSupport() {
    }

    static void permitAll(HttpSecurityBuilder<? extends HttpSecurityBuilder<?>> http, String ... urls) {
        for (String url : urls) {
            if (url == null) continue;
            PermitAllSupport.permitAll(http, new ExactUrlRequestMatcher(url));
        }
    }

    static void permitAll(HttpSecurityBuilder<? extends HttpSecurityBuilder<?>> http, RequestMatcher ... requestMatchers) {
        ExpressionUrlAuthorizationConfigurer configurer = http.getConfigurer(ExpressionUrlAuthorizationConfigurer.class);
        AuthorizeHttpRequestsConfigurer httpConfigurer = http.getConfigurer(AuthorizeHttpRequestsConfigurer.class);
        boolean oneConfigurerPresent = configurer == null ^ httpConfigurer == null;
        Assert.state((boolean)oneConfigurerPresent, (String)"permitAll only works with either HttpSecurity.authorizeRequests() or HttpSecurity.authorizeHttpRequests(). Please define one or the other but not both.");
        for (RequestMatcher matcher : requestMatchers) {
            if (matcher == null) continue;
            if (configurer != null) {
                configurer.getRegistry().addMapping(0, new AbstractConfigAttributeRequestMatcherRegistry.UrlMapping(matcher, SecurityConfig.createList((String[])new String[]{"permitAll"})));
                continue;
            }
            httpConfigurer.addFirst(matcher, AuthorizeHttpRequestsConfigurer.permitAllAuthorizationManager);
        }
    }

    private static final class ExactUrlRequestMatcher
    implements RequestMatcher {
        private String processUrl;

        private ExactUrlRequestMatcher(String processUrl) {
            this.processUrl = processUrl;
        }

        public boolean matches(HttpServletRequest request) {
            String uri = request.getRequestURI();
            String query = request.getQueryString();
            if (query != null) {
                uri = uri + "?" + query;
            }
            if ("".equals(request.getContextPath())) {
                return uri.equals(this.processUrl);
            }
            return uri.equals(request.getContextPath() + this.processUrl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ExactUrl [processUrl='").append(this.processUrl).append("']");
            return sb.toString();
        }
    }
}

