/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.config.core.GrantedAuthorityDefaults;

final class GrantedAuthorityDefaultsParserUtils {
    private GrantedAuthorityDefaultsParserUtils() {
    }

    static RootBeanDefinition registerWithDefaultRolePrefix(ParserContext pc, Class<? extends AbstractGrantedAuthorityDefaultsBeanFactory> beanFactoryClass) {
        RootBeanDefinition beanFactoryDefinition = new RootBeanDefinition(beanFactoryClass);
        String beanFactoryRef = pc.getReaderContext().generateBeanName((BeanDefinition)beanFactoryDefinition);
        pc.getRegistry().registerBeanDefinition(beanFactoryRef, (BeanDefinition)beanFactoryDefinition);
        RootBeanDefinition bean = new RootBeanDefinition();
        bean.setFactoryBeanName(beanFactoryRef);
        bean.setFactoryMethodName("getBean");
        return bean;
    }

    static abstract class AbstractGrantedAuthorityDefaultsBeanFactory
    implements ApplicationContextAware {
        protected String rolePrefix = "ROLE_";

        AbstractGrantedAuthorityDefaultsBeanFactory() {
        }

        public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            String[] grantedAuthorityDefaultsBeanNames = applicationContext.getBeanNamesForType(GrantedAuthorityDefaults.class);
            if (grantedAuthorityDefaultsBeanNames.length == 1) {
                GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)applicationContext.getBean(grantedAuthorityDefaultsBeanNames[0], GrantedAuthorityDefaults.class);
                this.rolePrefix = grantedAuthorityDefaults.getRolePrefix();
            }
        }

        abstract Object getBean();
    }
}

