/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.aop.Advisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.ObservationAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.SecuredAuthorizationManager;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class SecuredMethodSecurityConfiguration {
    SecuredMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static Advisor securedAuthorizationMethodInterceptor(ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<ObservationRegistry> registryProvider) {
        SecuredAuthorizationManager secured = new SecuredAuthorizationManager();
        SecurityContextHolderStrategy strategy = (SecurityContextHolderStrategy)strategyProvider.getIfAvailable(SecurityContextHolder::getContextHolderStrategy);
        ObservationRegistry registry = (ObservationRegistry)registryProvider.getIfAvailable(() -> ObservationRegistry.NOOP);
        AuthorizationManager manager = SecuredMethodSecurityConfiguration.manager(secured, registry);
        AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.secured(manager);
        interceptor.setSecurityContextHolderStrategy(strategy);
        return interceptor;
    }

    static <T> AuthorizationManager<T> manager(AuthorizationManager<T> jsr250, ObservationRegistry registry) {
        if (registry.isNoop()) {
            return jsr250;
        }
        return new ObservationAuthorizationManager(registry, jsr250);
    }
}

