/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.aop.Advisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerAfterMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationMethodInterceptor;
import org.springframework.security.config.annotation.method.configuration.DeferringObservationAuthorizationManager;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class PrePostMethodSecurityConfiguration {
    PrePostMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static Advisor preFilterAuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<MethodSecurityExpressionHandler> expressionHandlerProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ApplicationContext context) {
        PreFilterAuthorizationMethodInterceptor preFilter = new PreFilterAuthorizationMethodInterceptor();
        strategyProvider.ifAvailable(arg_0 -> ((PreFilterAuthorizationMethodInterceptor)preFilter).setSecurityContextHolderStrategy(arg_0));
        preFilter.setExpressionHandler((MethodSecurityExpressionHandler)expressionHandlerProvider.getIfAvailable(() -> PrePostMethodSecurityConfiguration.defaultExpressionHandler(defaultsProvider, context)));
        return preFilter;
    }

    @Bean
    @Role(value=2)
    static Advisor preAuthorizeAuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<MethodSecurityExpressionHandler> expressionHandlerProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<AuthorizationEventPublisher> eventPublisherProvider, ObjectProvider<ObservationRegistry> registryProvider, ApplicationContext context) {
        PreAuthorizeAuthorizationManager manager = new PreAuthorizeAuthorizationManager();
        manager.setExpressionHandler((MethodSecurityExpressionHandler)expressionHandlerProvider.getIfAvailable(() -> PrePostMethodSecurityConfiguration.defaultExpressionHandler(defaultsProvider, context)));
        AuthorizationManagerBeforeMethodInterceptor preAuthorize = AuthorizationManagerBeforeMethodInterceptor.preAuthorize(PrePostMethodSecurityConfiguration.manager(manager, registryProvider));
        strategyProvider.ifAvailable(arg_0 -> ((AuthorizationManagerBeforeMethodInterceptor)preAuthorize).setSecurityContextHolderStrategy(arg_0));
        eventPublisherProvider.ifAvailable(arg_0 -> ((AuthorizationManagerBeforeMethodInterceptor)preAuthorize).setAuthorizationEventPublisher(arg_0));
        return preAuthorize;
    }

    @Bean
    @Role(value=2)
    static Advisor postAuthorizeAuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<MethodSecurityExpressionHandler> expressionHandlerProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<AuthorizationEventPublisher> eventPublisherProvider, ObjectProvider<ObservationRegistry> registryProvider, ApplicationContext context) {
        PostAuthorizeAuthorizationManager manager = new PostAuthorizeAuthorizationManager();
        manager.setExpressionHandler((MethodSecurityExpressionHandler)expressionHandlerProvider.getIfAvailable(() -> PrePostMethodSecurityConfiguration.defaultExpressionHandler(defaultsProvider, context)));
        AuthorizationManagerAfterMethodInterceptor postAuthorize = AuthorizationManagerAfterMethodInterceptor.postAuthorize(PrePostMethodSecurityConfiguration.manager(manager, registryProvider));
        strategyProvider.ifAvailable(arg_0 -> ((AuthorizationManagerAfterMethodInterceptor)postAuthorize).setSecurityContextHolderStrategy(arg_0));
        eventPublisherProvider.ifAvailable(arg_0 -> ((AuthorizationManagerAfterMethodInterceptor)postAuthorize).setAuthorizationEventPublisher(arg_0));
        return postAuthorize;
    }

    @Bean
    @Role(value=2)
    static Advisor postFilterAuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<MethodSecurityExpressionHandler> expressionHandlerProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ApplicationContext context) {
        PostFilterAuthorizationMethodInterceptor postFilter = new PostFilterAuthorizationMethodInterceptor();
        strategyProvider.ifAvailable(arg_0 -> ((PostFilterAuthorizationMethodInterceptor)postFilter).setSecurityContextHolderStrategy(arg_0));
        postFilter.setExpressionHandler((MethodSecurityExpressionHandler)expressionHandlerProvider.getIfAvailable(() -> PrePostMethodSecurityConfiguration.defaultExpressionHandler(defaultsProvider, context)));
        return postFilter;
    }

    private static MethodSecurityExpressionHandler defaultExpressionHandler(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ApplicationContext context) {
        DefaultMethodSecurityExpressionHandler handler = new DefaultMethodSecurityExpressionHandler();
        defaultsProvider.ifAvailable(d -> handler.setDefaultRolePrefix(d.getRolePrefix()));
        handler.setApplicationContext(context);
        return handler;
    }

    static <T> AuthorizationManager<T> manager(AuthorizationManager<T> delegate, ObjectProvider<ObservationRegistry> registryProvider) {
        return new DeferringObservationAuthorizationManager<T>(registryProvider, delegate);
    }
}

