/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.rsocket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorityReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.rsocket.PayloadInterceptorOrder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtReactiveAuthenticationManager;
import org.springframework.security.rsocket.api.PayloadInterceptor;
import org.springframework.security.rsocket.authentication.AnonymousPayloadInterceptor;
import org.springframework.security.rsocket.authentication.AuthenticationPayloadExchangeConverter;
import org.springframework.security.rsocket.authentication.AuthenticationPayloadInterceptor;
import org.springframework.security.rsocket.authentication.BearerPayloadExchangeConverter;
import org.springframework.security.rsocket.authentication.PayloadExchangeAuthenticationConverter;
import org.springframework.security.rsocket.authorization.AuthorizationPayloadInterceptor;
import org.springframework.security.rsocket.authorization.PayloadExchangeMatcherReactiveAuthorizationManager;
import org.springframework.security.rsocket.core.PayloadSocketAcceptorInterceptor;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeAuthorizationContext;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatcher;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatcherEntry;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatchers;
import org.springframework.security.rsocket.util.matcher.RoutePayloadExchangeMatcher;
import reactor.core.publisher.Mono;

public class RSocketSecurity {
    private List<PayloadInterceptor> payloadInterceptors = new ArrayList<PayloadInterceptor>();
    private BasicAuthenticationSpec basicAuthSpec;
    private SimpleAuthenticationSpec simpleAuthSpec;
    private JwtSpec jwtSpec;
    private AuthorizePayloadsSpec authorizePayload;
    private ApplicationContext context;
    private ReactiveAuthenticationManager authenticationManager;

    public RSocketSecurity addPayloadInterceptor(PayloadInterceptor interceptor) {
        this.payloadInterceptors.add(interceptor);
        return this;
    }

    public RSocketSecurity authenticationManager(ReactiveAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        return this;
    }

    public RSocketSecurity simpleAuthentication(Customizer<SimpleAuthenticationSpec> simple) {
        if (this.simpleAuthSpec == null) {
            this.simpleAuthSpec = new SimpleAuthenticationSpec();
        }
        simple.customize(this.simpleAuthSpec);
        return this;
    }

    @Deprecated
    public RSocketSecurity basicAuthentication(Customizer<BasicAuthenticationSpec> basic) {
        if (this.basicAuthSpec == null) {
            this.basicAuthSpec = new BasicAuthenticationSpec();
        }
        basic.customize(this.basicAuthSpec);
        return this;
    }

    public RSocketSecurity jwt(Customizer<JwtSpec> jwt) {
        if (this.jwtSpec == null) {
            this.jwtSpec = new JwtSpec();
        }
        jwt.customize(this.jwtSpec);
        return this;
    }

    public RSocketSecurity authorizePayload(Customizer<AuthorizePayloadsSpec> authorize) {
        if (this.authorizePayload == null) {
            this.authorizePayload = new AuthorizePayloadsSpec();
        }
        authorize.customize(this.authorizePayload);
        return this;
    }

    public PayloadSocketAcceptorInterceptor build() {
        PayloadSocketAcceptorInterceptor interceptor = new PayloadSocketAcceptorInterceptor(this.payloadInterceptors());
        RSocketMessageHandler handler = this.getBean(RSocketMessageHandler.class);
        interceptor.setDefaultDataMimeType(handler.getDefaultDataMimeType());
        interceptor.setDefaultMetadataMimeType(handler.getDefaultMetadataMimeType());
        return interceptor;
    }

    private List<PayloadInterceptor> payloadInterceptors() {
        ArrayList<PayloadInterceptor> result = new ArrayList<PayloadInterceptor>(this.payloadInterceptors);
        if (this.basicAuthSpec != null) {
            result.add((PayloadInterceptor)this.basicAuthSpec.build());
        }
        if (this.simpleAuthSpec != null) {
            result.add((PayloadInterceptor)this.simpleAuthSpec.build());
        }
        if (this.jwtSpec != null) {
            result.addAll(this.jwtSpec.build());
        }
        result.add((PayloadInterceptor)this.anonymous());
        if (this.authorizePayload != null) {
            result.add((PayloadInterceptor)this.authorizePayload.build());
        }
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    private AnonymousPayloadInterceptor anonymous() {
        AnonymousPayloadInterceptor result = new AnonymousPayloadInterceptor("anonymousUser");
        result.setOrder(PayloadInterceptorOrder.ANONYMOUS.getOrder());
        return result;
    }

    private <T> T getBean(Class<T> beanClass) {
        if (this.context == null) {
            return null;
        }
        return (T)this.context.getBean(beanClass);
    }

    private <T> T getBeanOrNull(Class<T> beanClass) {
        return this.getBeanOrNull(ResolvableType.forClass(beanClass));
    }

    private <T> T getBeanOrNull(ResolvableType type) {
        if (this.context == null) {
            return null;
        }
        String[] names = this.context.getBeanNamesForType(type);
        if (names.length == 1) {
            return (T)this.context.getBean(names[0]);
        }
        return null;
    }

    protected void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public final class SimpleAuthenticationSpec {
        private ReactiveAuthenticationManager authenticationManager;

        private SimpleAuthenticationSpec() {
        }

        public SimpleAuthenticationSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager == null) {
                return RSocketSecurity.this.authenticationManager;
            }
            return this.authenticationManager;
        }

        protected AuthenticationPayloadInterceptor build() {
            ReactiveAuthenticationManager manager = this.getAuthenticationManager();
            AuthenticationPayloadInterceptor result = new AuthenticationPayloadInterceptor(manager);
            result.setAuthenticationConverter((PayloadExchangeAuthenticationConverter)new AuthenticationPayloadExchangeConverter());
            result.setOrder(PayloadInterceptorOrder.AUTHENTICATION.getOrder());
            return result;
        }
    }

    public final class BasicAuthenticationSpec {
        private ReactiveAuthenticationManager authenticationManager;

        private BasicAuthenticationSpec() {
        }

        public BasicAuthenticationSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager == null) {
                return RSocketSecurity.this.authenticationManager;
            }
            return this.authenticationManager;
        }

        protected AuthenticationPayloadInterceptor build() {
            ReactiveAuthenticationManager manager = this.getAuthenticationManager();
            AuthenticationPayloadInterceptor result = new AuthenticationPayloadInterceptor(manager);
            result.setOrder(PayloadInterceptorOrder.AUTHENTICATION.getOrder());
            return result;
        }
    }

    public final class JwtSpec {
        private ReactiveAuthenticationManager authenticationManager;

        private JwtSpec() {
        }

        public JwtSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager != null) {
                return this.authenticationManager;
            }
            ReactiveJwtDecoder jwtDecoder = RSocketSecurity.this.getBeanOrNull(ReactiveJwtDecoder.class);
            if (jwtDecoder != null) {
                this.authenticationManager = new JwtReactiveAuthenticationManager(jwtDecoder);
                return this.authenticationManager;
            }
            return RSocketSecurity.this.authenticationManager;
        }

        protected List<AuthenticationPayloadInterceptor> build() {
            ReactiveAuthenticationManager manager = this.getAuthenticationManager();
            AuthenticationPayloadInterceptor legacy = new AuthenticationPayloadInterceptor(manager);
            legacy.setAuthenticationConverter((PayloadExchangeAuthenticationConverter)new BearerPayloadExchangeConverter());
            legacy.setOrder(PayloadInterceptorOrder.AUTHENTICATION.getOrder());
            AuthenticationPayloadInterceptor standard = new AuthenticationPayloadInterceptor(manager);
            standard.setAuthenticationConverter((PayloadExchangeAuthenticationConverter)new AuthenticationPayloadExchangeConverter());
            standard.setOrder(PayloadInterceptorOrder.AUTHENTICATION.getOrder());
            return Arrays.asList(standard, legacy);
        }
    }

    public class AuthorizePayloadsSpec {
        private PayloadExchangeMatcherReactiveAuthorizationManager.Builder authzBuilder = PayloadExchangeMatcherReactiveAuthorizationManager.builder();

        public Access setup() {
            return this.matcher(PayloadExchangeMatchers.setup());
        }

        public Access anyRequest() {
            return this.matcher(PayloadExchangeMatchers.anyRequest());
        }

        public Access anyExchange() {
            return this.matcher(PayloadExchangeMatchers.anyExchange());
        }

        protected AuthorizationPayloadInterceptor build() {
            AuthorizationPayloadInterceptor result = new AuthorizationPayloadInterceptor((ReactiveAuthorizationManager)this.authzBuilder.build());
            result.setOrder(PayloadInterceptorOrder.AUTHORIZATION.getOrder());
            return result;
        }

        public Access route(String pattern) {
            RSocketMessageHandler handler = RSocketSecurity.this.getBean(RSocketMessageHandler.class);
            RoutePayloadExchangeMatcher matcher = new RoutePayloadExchangeMatcher(handler.getMetadataExtractor(), handler.getRouteMatcher(), pattern);
            return this.matcher((PayloadExchangeMatcher)matcher);
        }

        public Access matcher(PayloadExchangeMatcher matcher) {
            return new Access(matcher);
        }

        public final class Access {
            private final PayloadExchangeMatcher matcher;

            private Access(PayloadExchangeMatcher matcher) {
                this.matcher = matcher;
            }

            public AuthorizePayloadsSpec authenticated() {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)AuthenticatedReactiveAuthorizationManager.authenticated());
            }

            public AuthorizePayloadsSpec hasAuthority(String authority) {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)AuthorityReactiveAuthorizationManager.hasAuthority((String)authority));
            }

            public AuthorizePayloadsSpec hasRole(String role) {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)AuthorityReactiveAuthorizationManager.hasRole((String)role));
            }

            public AuthorizePayloadsSpec hasAnyRole(String ... roles) {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)AuthorityReactiveAuthorizationManager.hasAnyRole((String[])roles));
            }

            public AuthorizePayloadsSpec permitAll() {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)((ReactiveAuthorizationManager)(a, ctx) -> Mono.just((Object)new AuthorizationDecision(true))));
            }

            public AuthorizePayloadsSpec hasAnyAuthority(String ... authorities) {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)AuthorityReactiveAuthorizationManager.hasAnyAuthority((String[])authorities));
            }

            public AuthorizePayloadsSpec access(ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext> authorization) {
                AuthorizePayloadsSpec.this.authzBuilder.add(new PayloadExchangeMatcherEntry(this.matcher, authorization));
                return AuthorizePayloadsSpec.this;
            }

            public AuthorizePayloadsSpec denyAll() {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)((ReactiveAuthorizationManager)(a, ctx) -> Mono.just((Object)new AuthorizationDecision(false))));
            }
        }
    }
}

