/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.configurers.RequestMatcherBuilder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

final class AntPathRequestMatcherBuilder
implements RequestMatcherBuilder {
    private final String servletPath;

    private AntPathRequestMatcherBuilder(String servletPath) {
        this.servletPath = servletPath;
    }

    static AntPathRequestMatcherBuilder absolute() {
        return new AntPathRequestMatcherBuilder(null);
    }

    static AntPathRequestMatcherBuilder relativeTo(String path) {
        return new AntPathRequestMatcherBuilder(path);
    }

    public AntPathRequestMatcher matcher(String pattern) {
        return this.matcher((String)null, pattern);
    }

    public AntPathRequestMatcher matcher(HttpMethod method, String pattern) {
        return this.matcher(method != null ? method.name() : null, pattern);
    }

    private AntPathRequestMatcher matcher(String method, String pattern) {
        return new AntPathRequestMatcher(this.prependServletPath(pattern), method);
    }

    private String prependServletPath(String pattern) {
        if (this.servletPath == null) {
            return pattern;
        }
        return this.servletPath + pattern;
    }
}

