/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.ObservationAuthorizationManager;
import org.springframework.security.authorization.SpringAuthorizationEventPublisher;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AbstractRequestMatcherBuilderRegistry;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.RequestMatcherBuilder;
import org.springframework.security.config.annotation.web.configurers.RequestMatcherBuilders;
import org.springframework.security.config.annotation.web.configurers.ServletPatternRequestMatcher;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.access.intercept.RequestMatcherDelegatingAuthorizationManager;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcherEntry;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;

public final class AuthorizeHttpRequestsConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<AuthorizeHttpRequestsConfigurer<H>, H> {
    static final AuthorizationManager<RequestAuthorizationContext> permitAllAuthorizationManager = (a, o) -> new AuthorizationDecision(true);
    private final AuthorizationManagerRequestMatcherRegistry registry;
    private final AuthorizationEventPublisher publisher;
    private final Supplier<RoleHierarchy> roleHierarchy;
    private String rolePrefix = "ROLE_";

    public AuthorizeHttpRequestsConfigurer(ApplicationContext context) {
        this.registry = new AuthorizationManagerRequestMatcherRegistry(context);
        this.publisher = context.getBeanNamesForType(AuthorizationEventPublisher.class).length > 0 ? (AuthorizationEventPublisher)context.getBean(AuthorizationEventPublisher.class) : new SpringAuthorizationEventPublisher((ApplicationEventPublisher)context);
        this.roleHierarchy = SingletonSupplier.of(() -> context.getBeanNamesForType(RoleHierarchy.class).length > 0 ? (RoleHierarchy)context.getBean(RoleHierarchy.class) : new NullRoleHierarchy());
        String[] grantedAuthorityDefaultsBeanNames = context.getBeanNamesForType(GrantedAuthorityDefaults.class);
        if (grantedAuthorityDefaultsBeanNames.length > 0) {
            GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)context.getBean(GrantedAuthorityDefaults.class);
            this.rolePrefix = grantedAuthorityDefaults.getRolePrefix();
        }
    }

    public AuthorizationManagerRequestMatcherRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void configure(H http) {
        AuthorizationManager<HttpServletRequest> authorizationManager = this.registry.createAuthorizationManager();
        AuthorizationFilter authorizationFilter = new AuthorizationFilter(authorizationManager);
        authorizationFilter.setAuthorizationEventPublisher(this.publisher);
        authorizationFilter.setShouldFilterAllDispatcherTypes(this.registry.shouldFilterAllDispatcherTypes);
        authorizationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        http.addFilter((Filter)this.postProcess(authorizationFilter));
    }

    private AuthorizationManagerRequestMatcherRegistry addMapping(List<? extends RequestMatcher> matchers, AuthorizationManager<RequestAuthorizationContext> manager) {
        for (RequestMatcher requestMatcher : matchers) {
            this.registry.addMapping(requestMatcher, manager);
        }
        return this.registry;
    }

    AuthorizationManagerRequestMatcherRegistry addFirst(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
        this.registry.addFirst(matcher, manager);
        return this.registry;
    }

    private ObservationRegistry getObservationRegistry() {
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(ObservationRegistry.class);
        if (names.length == 1) {
            return (ObservationRegistry)context.getBean(ObservationRegistry.class);
        }
        return ObservationRegistry.NOOP;
    }

    public final class AuthorizationManagerRequestMatcherRegistry
    extends AbstractRequestMatcherBuilderRegistry<AuthorizedUrl> {
        private final RequestMatcherDelegatingAuthorizationManager.Builder managerBuilder;
        List<RequestMatcher> unmappedMatchers;
        private int mappingCount;
        private boolean shouldFilterAllDispatcherTypes;
        private final Map<String, org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry> servletPattern;

        AuthorizationManagerRequestMatcherRegistry(ApplicationContext context) {
            super(context);
            this.managerBuilder = RequestMatcherDelegatingAuthorizationManager.builder();
            this.shouldFilterAllDispatcherTypes = true;
            this.servletPattern = new LinkedHashMap<String, org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry>();
        }

        private void addMapping(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
            Assert.isTrue((boolean)this.servletPattern.isEmpty(), (String)"Since you have used forServletPattern, all request matchers must be configured using forServletPattern; alternatively, you can use requestMatchers(RequestMatcher) for all requests.");
            this.unmappedMatchers = null;
            this.managerBuilder.add(matcher, manager);
            ++this.mappingCount;
        }

        private void addFirst(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
            Assert.isTrue((boolean)this.servletPattern.isEmpty(), (String)"Since you have used forServletPattern, all request matchers must be configured using forServletPattern; alternatively, you can use requestMatchers(RequestMatcher) for all requests.");
            this.unmappedMatchers = null;
            this.managerBuilder.mappings(m -> m.add(0, new RequestMatcherEntry(matcher, (Object)manager)));
            ++this.mappingCount;
        }

        private AuthorizationManager<HttpServletRequest> servletAuthorizationManager() {
            for (Map.Entry<String, org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry> entry : this.servletPattern.entrySet()) {
                AuthorizationManagerServletRequestMatcherRegistry registry = (AuthorizationManagerServletRequestMatcherRegistry)entry.getValue();
                this.managerBuilder.add((RequestMatcher)new ServletPatternRequestMatcher(entry.getKey()), registry.authorizationManager());
            }
            return (AuthorizationManager)AuthorizeHttpRequestsConfigurer.this.postProcess(this.managerBuilder.build());
        }

        private AuthorizationManager<HttpServletRequest> authorizationManager() {
            Assert.state((this.unmappedMatchers == null ? 1 : 0) != 0, () -> "An incomplete mapping was found for " + this.unmappedMatchers + ". Try completing it with something like requestUrls().<something>.hasRole('USER')");
            Assert.state((this.mappingCount > 0 ? 1 : 0) != 0, (String)"At least one mapping is required (for example, authorizeHttpRequests().anyRequest().authenticated())");
            return (AuthorizationManager)AuthorizeHttpRequestsConfigurer.this.postProcess(this.managerBuilder.build());
        }

        private AuthorizationManager<HttpServletRequest> createAuthorizationManager() {
            AuthorizationManager<HttpServletRequest> manager = this.servletPattern.isEmpty() ? this.authorizationManager() : this.servletAuthorizationManager();
            ObservationRegistry registry = AuthorizeHttpRequestsConfigurer.this.getObservationRegistry();
            if (registry.isNoop()) {
                return manager;
            }
            return new ObservationAuthorizationManager(registry, manager);
        }

        @Override
        protected AuthorizedUrl chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            this.unmappedMatchers = requestMatchers;
            return new AuthorizedUrl(manager -> AuthorizeHttpRequestsConfigurer.this.addMapping(requestMatchers, (AuthorizationManager<RequestAuthorizationContext>)manager));
        }

        public AuthorizationManagerRequestMatcherRegistry forServletPattern(String pattern, Customizer<org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry> customizer) {
            ApplicationContext context = this.getApplicationContext();
            RequestMatcherBuilder builder = RequestMatcherBuilders.createForServletPattern(context, pattern);
            AuthorizationManagerServletRequestMatcherRegistry registry = new AuthorizationManagerServletRequestMatcherRegistry(builder);
            customizer.customize((org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry)registry);
            this.servletPattern.put(pattern, (org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry)registry);
            return this;
        }

        public AuthorizationManagerRequestMatcherRegistry withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
            AuthorizeHttpRequestsConfigurer.this.addObjectPostProcessor(objectPostProcessor);
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public AuthorizationManagerRequestMatcherRegistry shouldFilterAllDispatcherTypes(boolean shouldFilter) {
            this.shouldFilterAllDispatcherTypes = shouldFilter;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public H and() {
            return (HttpSecurityBuilder)AuthorizeHttpRequestsConfigurer.this.and();
        }

        public final class AuthorizationManagerServletRequestMatcherRegistry
        extends AbstractRequestMatcherBuilderRegistry<org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.ServletAuthorizedUrl> {
            private final RequestMatcherDelegatingAuthorizationManager.Builder managerBuilder;
            private List<RequestMatcher> unmappedMatchers;

            AuthorizationManagerServletRequestMatcherRegistry(RequestMatcherBuilder builder) {
                super(AuthorizationManagerRequestMatcherRegistry.this.getApplicationContext(), builder);
                this.managerBuilder = RequestMatcherDelegatingAuthorizationManager.builder();
            }

            AuthorizationManager<RequestAuthorizationContext> authorizationManager() {
                Assert.state((this.unmappedMatchers == null ? 1 : 0) != 0, () -> "An incomplete mapping was found for " + this.unmappedMatchers + ". Try completing it with something like requestUrls().<something>.hasRole('USER')");
                RequestMatcherDelegatingAuthorizationManager request = this.managerBuilder.build();
                return (arg_0, arg_1) -> AuthorizationManagerServletRequestMatcherRegistry.lambda$authorizationManager$1((AuthorizationManager)request, arg_0, arg_1);
            }

            @Override
            protected org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.ServletAuthorizedUrl chainRequestMatchers(List<RequestMatcher> requestMatchers) {
                this.unmappedMatchers = requestMatchers;
                return new ServletAuthorizedUrl(manager -> this.addMapping(requestMatchers, (AuthorizationManager)manager));
            }

            private org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry addMapping(List<RequestMatcher> matchers, AuthorizationManager<RequestAuthorizationContext> manager) {
                this.unmappedMatchers = null;
                for (RequestMatcher matcher : matchers) {
                    this.managerBuilder.add(matcher, manager);
                }
                return this;
            }

            private static /* synthetic */ AuthorizationDecision lambda$authorizationManager$1(AuthorizationManager request, Supplier authentication, RequestAuthorizationContext context) {
                return request.check(authentication, (Object)context.getRequest());
            }
        }

        public final class ServletAuthorizedUrl {
            private final Function<AuthorizationManager<RequestAuthorizationContext>, org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry> registrar;

            ServletAuthorizedUrl(Function<AuthorizationManager<RequestAuthorizationContext>, org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry> registrar) {
                this.registrar = registrar;
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry permitAll() {
                return this.access(permitAllAuthorizationManager);
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry denyAll() {
                return this.access((a, o) -> new AuthorizationDecision(false));
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry hasRole(String role) {
                return this.access((AuthorizationManager)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAnyRole((String)AuthorizeHttpRequestsConfigurer.this.rolePrefix, (String[])new String[]{role})));
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry hasAnyRole(String ... roles) {
                return this.access((AuthorizationManager)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAnyRole((String)AuthorizeHttpRequestsConfigurer.this.rolePrefix, (String[])roles)));
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry hasAuthority(String authority) {
                return this.access((AuthorizationManager)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAuthority((String)authority)));
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry hasAnyAuthority(String ... authorities) {
                return this.access((AuthorizationManager)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAnyAuthority((String[])authorities)));
            }

            private AuthorityAuthorizationManager<RequestAuthorizationContext> withRoleHierarchy(AuthorityAuthorizationManager<RequestAuthorizationContext> manager) {
                manager.setRoleHierarchy(AuthorizeHttpRequestsConfigurer.this.roleHierarchy.get());
                return manager;
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry authenticated() {
                return this.access((AuthorizationManager)AuthenticatedAuthorizationManager.authenticated());
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry fullyAuthenticated() {
                return this.access((AuthorizationManager)AuthenticatedAuthorizationManager.fullyAuthenticated());
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry rememberMe() {
                return this.access((AuthorizationManager)AuthenticatedAuthorizationManager.rememberMe());
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry anonymous() {
                return this.access((AuthorizationManager)AuthenticatedAuthorizationManager.anonymous());
            }

            public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry.AuthorizationManagerServletRequestMatcherRegistry access(AuthorizationManager<RequestAuthorizationContext> manager) {
                Assert.notNull(manager, (String)"manager cannot be null");
                return (AuthorizationManagerServletRequestMatcherRegistry)this.registrar.apply(manager);
            }
        }
    }

    public class AuthorizedUrl {
        private final Function<AuthorizationManager<RequestAuthorizationContext>, AuthorizationManagerRequestMatcherRegistry> registrar;

        AuthorizedUrl(Function<AuthorizationManager<RequestAuthorizationContext>, AuthorizationManagerRequestMatcherRegistry> registrar) {
            this.registrar = registrar;
        }

        public AuthorizationManagerRequestMatcherRegistry permitAll() {
            return this.access(permitAllAuthorizationManager);
        }

        public AuthorizationManagerRequestMatcherRegistry denyAll() {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)((AuthorizationManager)(a, o) -> new AuthorizationDecision(false)));
        }

        public AuthorizationManagerRequestMatcherRegistry hasRole(String role) {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAnyRole((String)AuthorizeHttpRequestsConfigurer.this.rolePrefix, (String[])new String[]{role})));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAnyRole(String ... roles) {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAnyRole((String)AuthorizeHttpRequestsConfigurer.this.rolePrefix, (String[])roles)));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAuthority(String authority) {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAuthority((String)authority)));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAnyAuthority(String ... authorities) {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAnyAuthority((String[])authorities)));
        }

        private AuthorityAuthorizationManager<RequestAuthorizationContext> withRoleHierarchy(AuthorityAuthorizationManager<RequestAuthorizationContext> manager) {
            manager.setRoleHierarchy(AuthorizeHttpRequestsConfigurer.this.roleHierarchy.get());
            return manager;
        }

        public AuthorizationManagerRequestMatcherRegistry authenticated() {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)AuthenticatedAuthorizationManager.authenticated());
        }

        public AuthorizationManagerRequestMatcherRegistry fullyAuthenticated() {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)AuthenticatedAuthorizationManager.fullyAuthenticated());
        }

        public AuthorizationManagerRequestMatcherRegistry rememberMe() {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)AuthenticatedAuthorizationManager.rememberMe());
        }

        public AuthorizationManagerRequestMatcherRegistry anonymous() {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)AuthenticatedAuthorizationManager.anonymous());
        }

        public AuthorizationManagerRequestMatcherRegistry access(AuthorizationManager<RequestAuthorizationContext> manager) {
            Assert.notNull(manager, (String)"manager cannot be null");
            return this.registrar.apply(manager);
        }
    }
}

