/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.configurers.RequestMatcherBuilder;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

final class MvcRequestMatcherBuilder
implements RequestMatcherBuilder {
    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
    private final HandlerMappingIntrospector introspector;
    private final ObjectPostProcessor<Object> objectPostProcessor;
    private final String servletPath;

    private MvcRequestMatcherBuilder(ApplicationContext context, String servletPath) {
        if (!context.containsBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
            throw new NoSuchBeanDefinitionException("A Bean named mvcHandlerMappingIntrospector of type " + HandlerMappingIntrospector.class.getName() + " is required to use MvcRequestMatcher. Please ensure Spring Security & Spring MVC are configured in a shared ApplicationContext.");
        }
        this.introspector = (HandlerMappingIntrospector)context.getBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, HandlerMappingIntrospector.class);
        this.objectPostProcessor = (ObjectPostProcessor)context.getBean(ObjectPostProcessor.class);
        this.servletPath = servletPath;
    }

    static MvcRequestMatcherBuilder absolute(ApplicationContext context) {
        return new MvcRequestMatcherBuilder(context, null);
    }

    static MvcRequestMatcherBuilder relativeTo(ApplicationContext context, String path) {
        return new MvcRequestMatcherBuilder(context, path);
    }

    public MvcRequestMatcher matcher(String pattern) {
        MvcRequestMatcher matcher = new MvcRequestMatcher(this.introspector, pattern);
        this.objectPostProcessor.postProcess(matcher);
        if (this.servletPath != null) {
            matcher.setServletPath(this.servletPath);
        }
        return matcher;
    }

    public MvcRequestMatcher matcher(HttpMethod method, String pattern) {
        MvcRequestMatcher matcher = new MvcRequestMatcher(this.introspector, pattern);
        this.objectPostProcessor.postProcess(matcher);
        matcher.setMethod(method);
        if (this.servletPath != null) {
            matcher.setServletPath(this.servletPath);
        }
        return matcher;
    }
}

