/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.configurers.AntPathRequestMatcherBuilder;
import org.springframework.security.config.annotation.web.configurers.DispatcherServletDelegatingRequestMatcherBuilder;
import org.springframework.security.config.annotation.web.configurers.MvcRequestMatcherBuilder;
import org.springframework.security.config.annotation.web.configurers.RequestMatcherBuilder;
import org.springframework.security.config.annotation.web.configurers.ServletRegistrationCollection;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class RequestMatcherBuilders {
    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
    private static final String HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final boolean mvcPresent = ClassUtils.isPresent((String)"org.springframework.web.servlet.handler.HandlerMappingIntrospector", (ClassLoader)RequestMatcherBuilders.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(RequestMatcherBuilders.class);

    private RequestMatcherBuilders() {
    }

    static RequestMatcherBuilder createDefault(ApplicationContext context) {
        if (!mvcPresent) {
            logger.trace((Object)"Defaulting to Ant matching since Spring MVC is not on the classpath");
            return AntPathRequestMatcherBuilder.absolute();
        }
        if (!context.containsBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
            logger.trace((Object)"Defaulting to Ant matching since Spring MVC is not fully configured");
            return AntPathRequestMatcherBuilder.absolute();
        }
        ServletRegistrationCollection registrations = ServletRegistrationCollection.registrations(context);
        if (registrations.isEmpty()) {
            logger.trace((Object)"Defaulting to MVC matching since Spring MVC is on the class path and no servlet information is available");
            return AntPathRequestMatcherBuilder.absolute();
        }
        ServletRegistrationCollection dispatcherServlets = registrations.dispatcherServlets();
        if (dispatcherServlets.isEmpty()) {
            logger.trace((Object)"Defaulting to Ant matching since there is no DispatcherServlet configured");
            return AntPathRequestMatcherBuilder.absolute();
        }
        ServletRegistrationCollection.ServletPath servletPath = registrations.deduceOneServletPath();
        if (servletPath != null) {
            String message = "Defaulting to MVC matching since DispatcherServlet [%s] is the only servlet mapping";
            logger.trace((Object)String.format(message, servletPath.path()));
            return MvcRequestMatcherBuilder.relativeTo(context, servletPath.path());
        }
        servletPath = dispatcherServlets.deduceOneServletPath();
        if (servletPath == null) {
            logger.trace((Object)"Did not choose a default since there is more than one DispatcherServlet mapping");
            String message = String.format("This method cannot decide whether these patterns are Spring MVC patterns or not\nsince your servlet configuration has multiple Spring MVC servlet mappings.\n\nFor your reference, here is your servlet configuration: %s\n\nTo address this, you need to specify the servlet path for each endpoint.\nYou can use .forServletPattern in conjunction with requestMatchers do to this\nlike so:\n\n@Bean\nSecurityFilterChain appSecurity(HttpSecurity http) throws Exception {\n\thttp\n\t\t.authorizeHttpRequests((authorize) -> authorize\n\t\t\t.forServletPattern(\"/mvc-one/*\", (one) -> one\n\t\t\t\t.requestMatchers(\"/controller/**\", \"/endpoints/**\"\n\t\t\t)...\n\t\t\t.forServletPattern(\"/mvc-two/*\", (two) -> two\n\t\t\t\t.requestMatchers(\"/other/**\", \"/controllers/**\")...\n\t\t\t)\n\t\t\t.forServletPattern(\"/h2-console/*\", (h2) -> h2\n\t\t\t\t.requestMatchers(\"/**\")...\n\t\t\t)\n\t\t)\n\t\t// ...\n\treturn http.build();\n}\n", registrations);
            return new ErrorRequestMatcherBuilder(message);
        }
        if (servletPath.path() != null) {
            logger.trace((Object)"Did not choose a default since there is a non-root DispatcherServlet mapping");
            String message = String.format("This method cannot decide whether these patterns are Spring MVC patterns or not\nsince your Spring MVC mapping is mapped to a path and you have other servlet mappings.\n\nFor your reference, here is your servlet configuration: %s\n\nTo address this, you need to specify the servlet path for each endpoint.\nYou can use .forServletPattern in conjunction with requestMatchers do to this\nlike so:\n\n@Bean\nSecurityFilterChain appSecurity(HttpSecurity http) throws Exception {\n\thttp\n\t\t.authorizeHttpRequests((authorize) -> authorize\n\t\t\t.forServletPattern(\"/mvc/*\", (mvc) -> mvc\n\t\t\t\t.requestMatchers(\"/controller/**\", \"/endpoints/**\")...\n\t\t\t)\n\t\t\t.forServletPattern(\"/h2-console/*\", (h2) -> h2\n\t\t\t\t.requestMatchers(\"/**\")...\n\t\t\t)\n\t\t)\n\t\t// ...\n\treturn http.build();\n}\n", registrations);
            return new ErrorRequestMatcherBuilder(message);
        }
        logger.trace((Object)"Defaulting to request-time checker since DispatcherServlet is mapped to root, but there are also other servlet mappings");
        return new DispatcherServletDelegatingRequestMatcherBuilder(MvcRequestMatcherBuilder.absolute(context), AntPathRequestMatcherBuilder.absolute(), registrations);
    }

    static RequestMatcherBuilder createForServletPattern(ApplicationContext context, String pattern) {
        boolean isPathPattern;
        Assert.notNull((Object)pattern, (String)"pattern cannot be null");
        ServletRegistrationCollection registrations = ServletRegistrationCollection.registrations(context);
        ServletRegistrationCollection.Registration registration = registrations.registrationByMapping(pattern);
        Assert.notNull((Object)registration, () -> String.format("The given pattern %s doesn't seem to match any configured servlets: %s", pattern, registrations));
        boolean bl = isPathPattern = pattern.startsWith("/") && pattern.endsWith("/*");
        if (isPathPattern) {
            String path = pattern.substring(0, pattern.length() - 2);
            return registration.isDispatcherServlet() ? MvcRequestMatcherBuilder.relativeTo(context, path) : AntPathRequestMatcherBuilder.relativeTo(path);
        }
        return registration.isDispatcherServlet() ? MvcRequestMatcherBuilder.absolute(context) : AntPathRequestMatcherBuilder.absolute();
    }

    private static class ErrorRequestMatcherBuilder
    implements RequestMatcherBuilder {
        private final String errorMessage;

        ErrorRequestMatcherBuilder(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public RequestMatcher matcher(String pattern) {
            throw new IllegalArgumentException(this.errorMessage);
        }

        @Override
        public RequestMatcher matcher(HttpMethod method, String pattern) {
            throw new IllegalArgumentException(this.errorMessage);
        }

        @Override
        public RequestMatcher any() {
            throw new IllegalArgumentException(this.errorMessage);
        }
    }
}

