/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

final class ServletPatternRequestMatcher
implements RequestMatcher {
    final String pattern;

    ServletPatternRequestMatcher(String pattern) {
        Assert.notNull((Object)pattern, (String)"pattern cannot be null");
        this.pattern = pattern;
    }

    public boolean matches(HttpServletRequest request) {
        return this.pattern.equals(request.getHttpServletMapping().getPattern());
    }

    public String toString() {
        return String.format("ServletPattern [pattern='%s']", this.pattern);
    }
}

