/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.WebApplicationContext;

final class ServletRegistrationCollection {
    private List<Registration> registrations;

    private ServletRegistrationCollection() {
        this.registrations = Collections.emptyList();
    }

    private ServletRegistrationCollection(List<Registration> registrations) {
        this.registrations = registrations;
    }

    static ServletRegistrationCollection registrations(ApplicationContext context) {
        if (!(context instanceof WebApplicationContext)) {
            return new ServletRegistrationCollection();
        }
        WebApplicationContext web = (WebApplicationContext)context;
        ServletContext servletContext = web.getServletContext();
        if (servletContext == null) {
            return new ServletRegistrationCollection();
        }
        Map registrations = servletContext.getServletRegistrations();
        if (registrations == null) {
            return new ServletRegistrationCollection();
        }
        ArrayList<Registration> filtered = new ArrayList<Registration>();
        for (ServletRegistration registration : registrations.values()) {
            Collection mappings = registration.getMappings();
            if (CollectionUtils.isEmpty((Collection)mappings)) continue;
            filtered.add(new Registration(registration));
        }
        return new ServletRegistrationCollection(filtered);
    }

    boolean isEmpty() {
        return this.registrations.isEmpty();
    }

    Registration registrationByName(String name) {
        for (Registration registration : this.registrations) {
            if (!registration.registration().getName().equals(name)) continue;
            return registration;
        }
        return null;
    }

    Registration registrationByMapping(String target) {
        for (Registration registration : this.registrations) {
            for (String mapping : registration.registration().getMappings()) {
                if (!target.equals(mapping)) continue;
                return registration;
            }
        }
        return null;
    }

    ServletRegistrationCollection dispatcherServlets() {
        ArrayList<Registration> dispatcherServlets = new ArrayList<Registration>();
        for (Registration registration : this.registrations) {
            if (!registration.isDispatcherServlet()) continue;
            dispatcherServlets.add(registration);
        }
        return new ServletRegistrationCollection(dispatcherServlets);
    }

    ServletPath deduceOneServletPath() {
        if (this.registrations.size() > 1) {
            return null;
        }
        ServletRegistration registration = this.registrations.iterator().next().registration();
        if (registration.getMappings().size() > 1) {
            return null;
        }
        String mapping = (String)registration.getMappings().iterator().next();
        if ("/".equals(mapping)) {
            return new ServletPath();
        }
        if (mapping.endsWith("/*")) {
            return new ServletPath(mapping.substring(0, mapping.length() - 2));
        }
        return null;
    }

    public String toString() {
        LinkedHashMap<String, Collection> mappings = new LinkedHashMap<String, Collection>();
        for (Registration registration : this.registrations) {
            mappings.put(registration.registration().getClassName(), registration.registration().getMappings());
        }
        return ((Object)mappings).toString();
    }

    record Registration(ServletRegistration registration) {
        boolean isDispatcherServlet() {
            Class dispatcherServlet = ClassUtils.resolveClassName((String)"org.springframework.web.servlet.DispatcherServlet", null);
            try {
                Class<?> clazz = Class.forName(this.registration.getClassName());
                if (dispatcherServlet.isAssignableFrom(clazz)) {
                    return true;
                }
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
            return false;
        }
    }

    record ServletPath(String path) {
        ServletPath() {
            this(null);
        }
    }
}

