/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.DispatcherTypeRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public abstract class AbstractRequestMatcherRegistry<C> {
    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
    private static final String HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final boolean mvcPresent;
    private static final RequestMatcher ANY_REQUEST;
    private ApplicationContext context;
    private boolean anyRequestConfigured = false;
    private final Log logger = LogFactory.getLog(this.getClass());

    protected final void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    protected final ApplicationContext getApplicationContext() {
        return this.context;
    }

    public C anyRequest() {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure anyRequest after itself");
        C configurer = this.requestMatchers(ANY_REQUEST);
        this.anyRequestConfigured = true;
        return configurer;
    }

    protected final List<MvcRequestMatcher> createMvcMatchers(HttpMethod method, String ... mvcPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure mvcMatchers after anyRequest");
        ObjectPostProcessor opp = (ObjectPostProcessor)this.context.getBean(ObjectPostProcessor.class);
        if (!this.context.containsBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
            throw new NoSuchBeanDefinitionException("A Bean named mvcHandlerMappingIntrospector of type " + HandlerMappingIntrospector.class.getName() + " is required to use MvcRequestMatcher. Please ensure Spring Security & Spring MVC are configured in a shared ApplicationContext.");
        }
        HandlerMappingIntrospector introspector = (HandlerMappingIntrospector)this.context.getBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, HandlerMappingIntrospector.class);
        ArrayList<MvcRequestMatcher> matchers = new ArrayList<MvcRequestMatcher>(mvcPatterns.length);
        for (String mvcPattern : mvcPatterns) {
            MvcRequestMatcher matcher = new MvcRequestMatcher(introspector, mvcPattern);
            opp.postProcess(matcher);
            if (method != null) {
                matcher.setMethod(method);
            }
            matchers.add(matcher);
        }
        return matchers;
    }

    public C dispatcherTypeMatchers(@Nullable HttpMethod method, DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
        for (DispatcherType dispatcherType : dispatcherTypes) {
            matchers.add((RequestMatcher)new DispatcherTypeRequestMatcher(dispatcherType, method));
        }
        return this.chainRequestMatchers(matchers);
    }

    public C dispatcherTypeMatchers(DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        return this.dispatcherTypeMatchers((HttpMethod)null, dispatcherTypes);
    }

    public C requestMatchers(RequestMatcher ... requestMatchers) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure requestMatchers after anyRequest");
        return this.chainRequestMatchers(Arrays.asList(requestMatchers));
    }

    public C requestMatchers(HttpMethod method, String ... patterns) {
        if (!mvcPresent) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        if (!(this.context instanceof WebApplicationContext)) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        WebApplicationContext context = (WebApplicationContext)this.context;
        ServletContext servletContext = context.getServletContext();
        if (servletContext == null) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        ArrayList<DeferredRequestMatcher> matchers = new ArrayList<DeferredRequestMatcher>();
        for (String pattern : patterns) {
            AntPathRequestMatcher ant = new AntPathRequestMatcher(pattern, method != null ? method.name() : null);
            MvcRequestMatcher mvc = this.createMvcMatchers(method, pattern).get(0);
            matchers.add(new DeferredRequestMatcher(c -> this.resolve(ant, mvc, (ServletContext)c), new RequestMatcher[]{mvc, ant}));
        }
        return this.requestMatchers(matchers.toArray(new RequestMatcher[0]));
    }

    private RequestMatcher resolve(AntPathRequestMatcher ant, MvcRequestMatcher mvc, ServletContext servletContext) {
        Map<String, ServletRegistration> registrations = this.mappableServletRegistrations(servletContext);
        if (registrations.isEmpty()) {
            return new DispatcherServletDelegatingRequestMatcher(ant, mvc, new MockMvcRequestMatcher());
        }
        if (!this.hasDispatcherServlet(registrations)) {
            return new DispatcherServletDelegatingRequestMatcher(ant, mvc, new MockMvcRequestMatcher());
        }
        ServletRegistration dispatcherServlet = this.requireOneRootDispatcherServlet(registrations);
        if (dispatcherServlet != null) {
            if (registrations.size() == 1) {
                return mvc;
            }
            return new DispatcherServletDelegatingRequestMatcher(ant, mvc, servletContext);
        }
        dispatcherServlet = this.requireOnlyPathMappedDispatcherServlet(registrations);
        if (dispatcherServlet != null) {
            String mapping = (String)dispatcherServlet.getMappings().iterator().next();
            mvc.setServletPath(mapping.substring(0, mapping.length() - 2));
            return mvc;
        }
        String errorMessage = AbstractRequestMatcherRegistry.computeErrorMessage(registrations.values());
        throw new IllegalArgumentException(errorMessage);
    }

    private Map<String, ? extends ServletRegistration> mappableServletRegistrations(ServletContext servletContext) {
        LinkedHashMap<String, ServletRegistration> mappable = new LinkedHashMap<String, ServletRegistration>();
        for (Map.Entry entry : servletContext.getServletRegistrations().entrySet()) {
            if (((ServletRegistration)entry.getValue()).getMappings().isEmpty()) continue;
            mappable.put((String)entry.getKey(), (ServletRegistration)entry.getValue());
        }
        return mappable;
    }

    private boolean hasDispatcherServlet(Map<String, ? extends ServletRegistration> registrations) {
        if (registrations == null) {
            return false;
        }
        for (ServletRegistration servletRegistration : registrations.values()) {
            if (!this.isDispatcherServlet(servletRegistration)) continue;
            return true;
        }
        return false;
    }

    private ServletRegistration requireOneRootDispatcherServlet(Map<String, ? extends ServletRegistration> registrations) {
        ServletRegistration rootDispatcherServlet = null;
        for (ServletRegistration servletRegistration : registrations.values()) {
            if (!this.isDispatcherServlet(servletRegistration)) continue;
            if (servletRegistration.getMappings().size() > 1) {
                return null;
            }
            if (!"/".equals(servletRegistration.getMappings().iterator().next())) {
                return null;
            }
            rootDispatcherServlet = servletRegistration;
        }
        return rootDispatcherServlet;
    }

    private ServletRegistration requireOnlyPathMappedDispatcherServlet(Map<String, ? extends ServletRegistration> registrations) {
        ServletRegistration pathDispatcherServlet = null;
        for (ServletRegistration servletRegistration : registrations.values()) {
            if (!this.isDispatcherServlet(servletRegistration)) {
                return null;
            }
            if (servletRegistration.getMappings().size() > 1) {
                return null;
            }
            String mapping = (String)servletRegistration.getMappings().iterator().next();
            if (!mapping.startsWith("/") || !mapping.endsWith("/*")) {
                return null;
            }
            if (pathDispatcherServlet != null) {
                return null;
            }
            pathDispatcherServlet = servletRegistration;
        }
        return pathDispatcherServlet;
    }

    private boolean isDispatcherServlet(ServletRegistration registration) {
        Class dispatcherServlet = ClassUtils.resolveClassName((String)"org.springframework.web.servlet.DispatcherServlet", null);
        try {
            Class<?> clazz = Class.forName(registration.getClassName());
            return dispatcherServlet.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static String computeErrorMessage(Collection<? extends ServletRegistration> registrations) {
        String template = "This method cannot decide whether these patterns are Spring MVC patterns or not. If this endpoint is a Spring MVC endpoint, please use requestMatchers(MvcRequestMatcher); otherwise, please use requestMatchers(AntPathRequestMatcher).\n\nThis is because there is more than one mappable servlet in your servlet context: %s.\n\nFor each MvcRequestMatcher, call MvcRequestMatcher#setServletPath to indicate the servlet path.";
        LinkedHashMap<String, Collection> mappings = new LinkedHashMap<String, Collection>();
        for (ServletRegistration servletRegistration : registrations) {
            mappings.put(servletRegistration.getClassName(), servletRegistration.getMappings());
        }
        return String.format(template, mappings);
    }

    public C requestMatchers(String ... patterns) {
        return this.requestMatchers((HttpMethod)null, patterns);
    }

    public C requestMatchers(HttpMethod method) {
        return this.requestMatchers(method, "/**");
    }

    protected abstract C chainRequestMatchers(List<RequestMatcher> var1);

    static {
        ANY_REQUEST = AnyRequestMatcher.INSTANCE;
        mvcPresent = ClassUtils.isPresent((String)HANDLER_MAPPING_INTROSPECTOR, (ClassLoader)AbstractRequestMatcherRegistry.class.getClassLoader());
    }

    private static final class RequestMatchers {
        private RequestMatchers() {
        }

        static List<RequestMatcher> antMatchers(HttpMethod httpMethod, String ... antPatterns) {
            return Arrays.asList(RequestMatchers.antMatchersAsArray(httpMethod, antPatterns));
        }

        static List<RequestMatcher> antMatchers(String ... antPatterns) {
            return RequestMatchers.antMatchers(null, antPatterns);
        }

        static RequestMatcher[] antMatchersAsArray(HttpMethod httpMethod, String ... antPatterns) {
            String method = httpMethod != null ? httpMethod.toString() : null;
            RequestMatcher[] matchers = new RequestMatcher[antPatterns.length];
            for (int index = 0; index < antPatterns.length; ++index) {
                matchers[index] = new AntPathRequestMatcher(antPatterns[index], method);
            }
            return matchers;
        }

        static List<RequestMatcher> regexMatchers(HttpMethod httpMethod, String ... regexPatterns) {
            String method = httpMethod != null ? httpMethod.toString() : null;
            ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
            for (String pattern : regexPatterns) {
                matchers.add((RequestMatcher)new RegexRequestMatcher(pattern, method));
            }
            return matchers;
        }

        static List<RequestMatcher> regexMatchers(String ... regexPatterns) {
            return RequestMatchers.regexMatchers(null, regexPatterns);
        }
    }

    static class DeferredRequestMatcher
    implements RequestMatcher {
        final Function<ServletContext, RequestMatcher> requestMatcherFactory;
        final AtomicReference<String> description = new AtomicReference();
        final Map<ServletContext, RequestMatcher> requestMatchers = new ConcurrentHashMap<ServletContext, RequestMatcher>();

        DeferredRequestMatcher(Function<ServletContext, RequestMatcher> resolver, RequestMatcher ... candidates) {
            this.requestMatcherFactory = sc -> this.requestMatchers.computeIfAbsent((ServletContext)sc, resolver);
            this.description.set("Deferred " + Arrays.toString(candidates));
        }

        RequestMatcher requestMatcher(ServletContext servletContext) {
            return this.requestMatcherFactory.apply(servletContext);
        }

        public boolean matches(HttpServletRequest request) {
            return this.requestMatcherFactory.apply(request.getServletContext()).matches(request);
        }

        public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
            return this.requestMatcherFactory.apply(request.getServletContext()).matcher(request);
        }

        public String toString() {
            return this.description.get();
        }
    }

    static class DispatcherServletDelegatingRequestMatcher
    implements RequestMatcher {
        private final AntPathRequestMatcher ant;
        private final MvcRequestMatcher mvc;
        private final RequestMatcher dispatcherServlet;

        DispatcherServletDelegatingRequestMatcher(AntPathRequestMatcher ant, MvcRequestMatcher mvc, ServletContext servletContext) {
            this(ant, mvc, (RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{new MockMvcRequestMatcher(), new DispatcherServletRequestMatcher(servletContext)}));
        }

        DispatcherServletDelegatingRequestMatcher(AntPathRequestMatcher ant, MvcRequestMatcher mvc, RequestMatcher dispatcherServlet) {
            this.ant = ant;
            this.mvc = mvc;
            this.dispatcherServlet = dispatcherServlet;
        }

        RequestMatcher requestMatcher(HttpServletRequest request) {
            if (this.dispatcherServlet.matches(request)) {
                return this.mvc;
            }
            return this.ant;
        }

        public boolean matches(HttpServletRequest request) {
            return this.requestMatcher(request).matches(request);
        }

        public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
            return this.requestMatcher(request).matcher(request);
        }

        public String toString() {
            return "DispatcherServletDelegating [ant = " + this.ant + ", mvc = " + this.mvc + "]";
        }
    }

    static class MockMvcRequestMatcher
    implements RequestMatcher {
        MockMvcRequestMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            return request.getAttribute("org.springframework.test.web.servlet.MockMvc.MVC_RESULT_ATTRIBUTE") != null;
        }
    }

    static class DispatcherServletRequestMatcher
    implements RequestMatcher {
        private final ServletContext servletContext;

        DispatcherServletRequestMatcher(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public boolean matches(HttpServletRequest request) {
            String name = request.getHttpServletMapping().getServletName();
            ServletRegistration registration = this.servletContext.getServletRegistration(name);
            Assert.notNull((Object)registration, (String)AbstractRequestMatcherRegistry.computeErrorMessage(this.servletContext.getServletRegistrations().values()));
            try {
                Class<?> clazz = Class.forName(registration.getClassName());
                return DispatcherServlet.class.isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
    }
}

