/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.DelegatingMissingAuthorityAccessDeniedHandler;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.RequestMatcherDelegatingAccessDeniedHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class ExceptionHandlingConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<ExceptionHandlingConfigurer<H>, H> {
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AccessDeniedHandler accessDeniedHandler;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable DelegatingAuthenticationEntryPoint.Builder defaultEntryPoint;
    private LinkedHashMap<RequestMatcher, AccessDeniedHandler> defaultDeniedHandlerMappings = new LinkedHashMap();
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable DelegatingMissingAuthorityAccessDeniedHandler.Builder missingAuthoritiesHandlerBuilder;

    public ExceptionHandlingConfigurer<H> accessDeniedPage(String accessDeniedUrl) {
        AccessDeniedHandlerImpl accessDeniedHandler = new AccessDeniedHandlerImpl();
        accessDeniedHandler.setErrorPage(accessDeniedUrl);
        return this.accessDeniedHandler((AccessDeniedHandler)accessDeniedHandler);
    }

    public ExceptionHandlingConfigurer<H> accessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        this.accessDeniedHandler = accessDeniedHandler;
        return this;
    }

    public ExceptionHandlingConfigurer<H> defaultAccessDeniedHandlerFor(AccessDeniedHandler deniedHandler, RequestMatcher preferredMatcher) {
        this.defaultDeniedHandlerMappings.put(preferredMatcher, deniedHandler);
        return this;
    }

    public ExceptionHandlingConfigurer<H> defaultDeniedHandlerForMissingAuthority(AuthenticationEntryPoint entryPoint, String authority) {
        if (this.missingAuthoritiesHandlerBuilder == null) {
            this.missingAuthoritiesHandlerBuilder = DelegatingMissingAuthorityAccessDeniedHandler.builder();
        }
        this.missingAuthoritiesHandlerBuilder.addEntryPointFor(entryPoint, authority);
        return this;
    }

    public ExceptionHandlingConfigurer<H> defaultDeniedHandlerForMissingAuthority(Consumer<DelegatingAuthenticationEntryPoint.Builder> entryPoint, String authority) {
        if (this.missingAuthoritiesHandlerBuilder == null) {
            this.missingAuthoritiesHandlerBuilder = DelegatingMissingAuthorityAccessDeniedHandler.builder();
        }
        this.missingAuthoritiesHandlerBuilder.addEntryPointFor(entryPoint, authority);
        return this;
    }

    public ExceptionHandlingConfigurer<H> authenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
        return this;
    }

    public ExceptionHandlingConfigurer<H> defaultAuthenticationEntryPointFor(AuthenticationEntryPoint entryPoint, RequestMatcher preferredMatcher) {
        if (this.defaultEntryPoint == null) {
            this.defaultEntryPoint = DelegatingAuthenticationEntryPoint.builder();
        }
        this.defaultEntryPoint.addEntryPointFor(entryPoint, preferredMatcher);
        return this;
    }

    AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    AccessDeniedHandler getAccessDeniedHandler() {
        return this.accessDeniedHandler;
    }

    @Override
    public void configure(H http) {
        AuthenticationEntryPoint entryPoint = this.getAuthenticationEntryPoint(http);
        ExceptionTranslationFilter exceptionTranslationFilter = new ExceptionTranslationFilter(entryPoint, this.getRequestCache(http));
        AccessDeniedHandler deniedHandler = this.getAccessDeniedHandler(http);
        exceptionTranslationFilter.setAccessDeniedHandler(deniedHandler);
        exceptionTranslationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        exceptionTranslationFilter = this.postProcess(exceptionTranslationFilter);
        http.addFilter((Filter)exceptionTranslationFilter);
    }

    AccessDeniedHandler getAccessDeniedHandler(H http) {
        AccessDeniedHandler deniedHandler = this.accessDeniedHandler;
        if (deniedHandler == null) {
            deniedHandler = this.createDefaultDeniedHandler(http);
        }
        return deniedHandler;
    }

    AuthenticationEntryPoint getAuthenticationEntryPoint(H http) {
        AuthenticationEntryPoint entryPoint = this.authenticationEntryPoint;
        if (entryPoint == null) {
            entryPoint = this.createDefaultEntryPoint(http);
        }
        return entryPoint;
    }

    private AccessDeniedHandler createDefaultDeniedHandler(H http) {
        AccessDeniedHandler defaults = this.createDefaultAccessDeniedHandler(http);
        if (this.missingAuthoritiesHandlerBuilder == null) {
            return defaults;
        }
        DelegatingMissingAuthorityAccessDeniedHandler deniedHandler = this.missingAuthoritiesHandlerBuilder.build();
        deniedHandler.setRequestCache(this.getRequestCache(http));
        deniedHandler.setDefaultAccessDeniedHandler(defaults);
        return deniedHandler;
    }

    private AccessDeniedHandler createDefaultAccessDeniedHandler(H http) {
        if (this.defaultDeniedHandlerMappings.isEmpty()) {
            return new AccessDeniedHandlerImpl();
        }
        if (this.defaultDeniedHandlerMappings.size() == 1) {
            return this.defaultDeniedHandlerMappings.values().iterator().next();
        }
        return new RequestMatcherDelegatingAccessDeniedHandler(this.defaultDeniedHandlerMappings, (AccessDeniedHandler)new AccessDeniedHandlerImpl());
    }

    private AuthenticationEntryPoint createDefaultEntryPoint(H http) {
        if (this.defaultEntryPoint == null) {
            return new Http403ForbiddenEntryPoint();
        }
        return this.defaultEntryPoint.build();
    }

    private RequestCache getRequestCache(H http) {
        RequestCache result = http.getSharedObject(RequestCache.class);
        if (result != null) {
            return result;
        }
        return new HttpSessionRequestCache();
    }
}

