/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.RequestCacheAwareFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

public final class RequestCacheConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<RequestCacheConfigurer<H>, H> {
    public RequestCacheConfigurer<H> requestCache(RequestCache requestCache) {
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(RequestCache.class, requestCache);
        return this;
    }

    @Override
    public H disable() {
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(RequestCache.class, new NullRequestCache());
        return (H)super.disable();
    }

    @Override
    public void init(H http) {
        http.setSharedObject(RequestCache.class, (RequestCache)this.getRequestCache(http));
    }

    @Override
    public void configure(H http) {
        RequestCache requestCache = this.getRequestCache(http);
        RequestCacheAwareFilter requestCacheFilter = new RequestCacheAwareFilter(requestCache);
        requestCacheFilter = this.postProcess(requestCacheFilter);
        http.addFilter((Filter)requestCacheFilter);
    }

    private RequestCache getRequestCache(H http) {
        RequestCache result = http.getSharedObject(RequestCache.class);
        if (result != null) {
            return result;
        }
        result = this.getBeanOrNull(RequestCache.class);
        if (result != null) {
            return result;
        }
        HttpSessionRequestCache defaultCache = new HttpSessionRequestCache();
        defaultCache.setRequestMatcher(this.createDefaultSavedRequestMatcher(http));
        return defaultCache;
    }

    private <T> T getBeanOrNull(Class<T> type) {
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        return (T)context.getBeanProvider(type).getIfUnique();
    }

    private RequestMatcher createDefaultSavedRequestMatcher(H http) {
        NegatedRequestMatcher notFavIcon = new NegatedRequestMatcher(this.getFaviconRequestMatcher());
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        NegatedRequestMatcher notWebSocket = new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("Upgrade", "websocket"));
        boolean isCsrfEnabled = http.getConfigurer(CsrfConfigurer.class) != null;
        ArrayList<Object> matchers = new ArrayList<Object>();
        if (isCsrfEnabled) {
            PathPatternRequestMatcher getRequests = this.getRequestMatcherBuilder().matcher(HttpMethod.GET, "/**");
            matchers.add(0, getRequests);
        }
        matchers.add(notFavIcon);
        matchers.add(this.notMatchingMediaType(http, MediaType.APPLICATION_JSON));
        matchers.add(notXRequestedWith);
        matchers.add(this.notMatchingMediaType(http, MediaType.MULTIPART_FORM_DATA));
        matchers.add(this.notMatchingMediaType(http, MediaType.TEXT_EVENT_STREAM));
        matchers.add(notWebSocket);
        return new AndRequestMatcher(matchers);
    }

    private RequestMatcher notMatchingMediaType(H http, MediaType mediaType) {
        ContentNegotiationStrategy contentNegotiationStrategy = http.getSharedObject(ContentNegotiationStrategy.class);
        if (contentNegotiationStrategy == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        MediaTypeRequestMatcher mediaRequest = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{mediaType});
        mediaRequest.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        return new NegatedRequestMatcher((RequestMatcher)mediaRequest);
    }

    private RequestMatcher getFaviconRequestMatcher() {
        return this.getRequestMatcherBuilder().matcher("/favicon.*");
    }
}

