/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.password;

import java.security.MessageDigest;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.password.AbstractValidatingPasswordEncoder;
import org.springframework.security.crypto.util.EncodingUtils;

public abstract class AbstractPasswordEncoder
extends AbstractValidatingPasswordEncoder {
    private final BytesKeyGenerator saltGenerator = KeyGenerators.secureRandom();

    protected AbstractPasswordEncoder() {
    }

    @Override
    protected String encodeNonNullPassword(String rawPassword) {
        byte[] salt = this.saltGenerator.generateKey();
        byte[] encoded = this.encodeAndConcatenate(rawPassword, salt);
        return String.valueOf(Hex.encode(encoded));
    }

    @Override
    protected boolean matchesNonNull(String rawPassword, String encodedPassword) {
        byte[] digested = Hex.decode(encodedPassword);
        byte[] salt = EncodingUtils.subArray(digested, 0, this.saltGenerator.getKeyLength());
        return AbstractPasswordEncoder.matchesNonNull(digested, this.encodeAndConcatenate(rawPassword, salt));
    }

    protected abstract byte[] encodedNonNullPassword(CharSequence var1, byte[] var2);

    protected byte[] encodeAndConcatenate(CharSequence rawPassword, byte[] salt) {
        return EncodingUtils.concatenate(salt, this.encodedNonNullPassword(rawPassword, salt));
    }

    protected static boolean matchesNonNull(byte[] expected, byte[] actual) {
        return MessageDigest.isEqual(expected, actual);
    }
}

