/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.ppolicy;

import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.ldap.ppolicy.PasswordPolicyResponseControl;

public final class PasswordPolicyControlExtractor {
    private static final Log logger = LogFactory.getLog(PasswordPolicyControlExtractor.class);

    private PasswordPolicyControlExtractor() {
    }

    public static PasswordPolicyResponseControl extractControl(DirContext dirCtx) {
        LdapContext ctx = (LdapContext)dirCtx;
        Control[] ctrls = null;
        try {
            ctrls = ctx.getResponseControls();
        }
        catch (NamingException ex) {
            logger.error((Object)"Failed to obtain response controls", (Throwable)ex);
        }
        for (int i = 0; ctrls != null && i < ctrls.length; ++i) {
            if (!(ctrls[i] instanceof PasswordPolicyResponseControl)) continue;
            return (PasswordPolicyResponseControl)ctrls[i];
        }
        return null;
    }
}

