/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.ppolicy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import netscape.ldap.ber.stream.BERChoice;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERIntegral;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.ber.stream.BERTagDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.ldap.ppolicy.PasswordPolicyControl;
import org.springframework.security.ldap.ppolicy.PasswordPolicyErrorStatus;

public class PasswordPolicyResponseControl
extends PasswordPolicyControl {
    private static final Log logger = LogFactory.getLog(PasswordPolicyResponseControl.class);
    private final byte[] encodedValue;
    private PasswordPolicyErrorStatus errorStatus;
    private int graceLoginsRemaining = Integer.MAX_VALUE;
    private int timeBeforeExpiration = Integer.MAX_VALUE;

    public PasswordPolicyResponseControl(byte[] encodedValue) {
        this.encodedValue = encodedValue;
        NetscapeDecoder decoder = new NetscapeDecoder();
        try {
            decoder.decode();
        }
        catch (IOException ex) {
            throw new DataRetrievalFailureException("Failed to parse control value", (Throwable)ex);
        }
    }

    @Override
    public byte[] getEncodedValue() {
        return this.encodedValue;
    }

    public PasswordPolicyErrorStatus getErrorStatus() {
        return this.errorStatus;
    }

    public int getGraceLoginsRemaining() {
        return this.graceLoginsRemaining;
    }

    public int getTimeBeforeExpiration() {
        return this.timeBeforeExpiration;
    }

    public boolean hasError() {
        return this.errorStatus != null;
    }

    public boolean hasWarning() {
        return this.graceLoginsRemaining != Integer.MAX_VALUE || this.timeBeforeExpiration != Integer.MAX_VALUE;
    }

    public boolean isExpired() {
        return this.errorStatus == PasswordPolicyErrorStatus.PASSWORD_EXPIRED;
    }

    public boolean isChangeAfterReset() {
        return this.errorStatus == PasswordPolicyErrorStatus.CHANGE_AFTER_RESET;
    }

    public boolean isUsingGraceLogins() {
        return this.graceLoginsRemaining < Integer.MAX_VALUE;
    }

    public boolean isLocked() {
        return this.errorStatus == PasswordPolicyErrorStatus.ACCOUNT_LOCKED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        if (this.hasError()) {
            sb.append("error=").append(this.errorStatus.getDefaultMessage()).append("; ");
        }
        if (this.graceLoginsRemaining != Integer.MAX_VALUE) {
            sb.append("warning=").append(this.graceLoginsRemaining).append(" grace logins remain; ");
        }
        if (this.timeBeforeExpiration != Integer.MAX_VALUE) {
            sb.append("warning=time before expiration is ").append(this.timeBeforeExpiration).append("; ");
        }
        if (!this.hasError() && !this.hasWarning()) {
            sb.append("(no error, no warning)");
        }
        sb.append("]");
        return sb.toString();
    }

    private class NetscapeDecoder
    implements PPolicyDecoder {
        private NetscapeDecoder() {
        }

        @Override
        public void decode() throws IOException {
            int[] bread = new int[]{0};
            BERSequence seq = (BERSequence)BERElement.getElement((BERTagDecoder)new SpecificTagDecoder(), (InputStream)new ByteArrayInputStream(PasswordPolicyResponseControl.this.encodedValue), (int[])bread);
            int size = seq.size();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)LogMessage.format((String)"Received PasswordPolicyResponse whose ASN.1 sequence has %d elements", (Object)size));
            }
            for (int i = 0; i < seq.size(); ++i) {
                BERTag elt = (BERTag)seq.elementAt(i);
                int tag = elt.getTag() & 0x1F;
                if (tag == 0) {
                    BERChoice warning = (BERChoice)elt.getValue();
                    BERTag content = (BERTag)warning.getValue();
                    int value = ((BERInteger)content.getValue()).getValue();
                    if ((content.getTag() & 0x1F) == 0) {
                        PasswordPolicyResponseControl.this.timeBeforeExpiration = value;
                        continue;
                    }
                    PasswordPolicyResponseControl.this.graceLoginsRemaining = value;
                    continue;
                }
                if (tag != 1) continue;
                BERIntegral error = (BERIntegral)elt.getValue();
                PasswordPolicyResponseControl.this.errorStatus = PasswordPolicyErrorStatus.values()[error.getValue()];
            }
        }

        class SpecificTagDecoder
        extends BERTagDecoder {
            private Boolean inChoice = null;

            SpecificTagDecoder() {
            }

            public BERElement getElement(BERTagDecoder decoder, int tag, InputStream stream, int[] bytesRead, boolean[] implicit) throws IOException {
                implicit[0] = false;
                if ((tag &= 0x1F) == 0) {
                    if (this.inChoice == null) {
                        this.setInChoice(true);
                        BERElement.readLengthOctets((InputStream)stream, (int[])bytesRead);
                        int[] componentLength = new int[1];
                        BERChoice choice = new BERChoice(decoder, stream, componentLength);
                        bytesRead[0] = bytesRead[0] + componentLength[0];
                        return choice;
                    }
                    return new BERInteger(stream, bytesRead);
                }
                if (tag == 1) {
                    if (this.inChoice == null) {
                        this.setInChoice(false);
                        return new BEREnumerated(stream, bytesRead);
                    }
                    if (this.inChoice.booleanValue()) {
                        return new BERInteger(stream, bytesRead);
                    }
                }
                throw new DataRetrievalFailureException("Unexpected tag " + tag);
            }

            private void setInChoice(boolean inChoice) {
                this.inChoice = inChoice;
            }
        }
    }

    private static interface PPolicyDecoder {
        public void decode() throws IOException;
    }
}

