/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.util.matcher;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.util.Assert;

abstract class AbstractMessageMatcherComposite<T>
implements MessageMatcher<T> {
    protected final Log LOGGER = LogFactory.getLog(this.getClass());
    private final List<MessageMatcher<T>> messageMatchers;

    AbstractMessageMatcherComposite(List<MessageMatcher<T>> messageMatchers) {
        Assert.notEmpty(messageMatchers, (String)"messageMatchers must contain a value");
        if (messageMatchers.contains(null)) {
            throw new IllegalArgumentException("messageMatchers cannot contain null values");
        }
        this.messageMatchers = messageMatchers;
    }

    @SafeVarargs
    AbstractMessageMatcherComposite(MessageMatcher<T> ... messageMatchers) {
        this(Arrays.asList(messageMatchers));
    }

    public List<MessageMatcher<T>> getMessageMatchers() {
        return this.messageMatchers;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[messageMatchers=" + this.messageMatchers + "]";
    }
}

