/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import javax.servlet.Filter;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ConfigurerUtils;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcClientRegistrationEndpointFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class OidcClientRegistrationEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;

    OidcClientRegistrationEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void init(B builder) {
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        this.requestMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(providerSettings.getOidcClientRegistrationEndpoint(), HttpMethod.POST.name()), new AntPathRequestMatcher(providerSettings.getOidcClientRegistrationEndpoint(), HttpMethod.GET.name())});
        OidcClientRegistrationAuthenticationProvider oidcClientRegistrationAuthenticationProvider = new OidcClientRegistrationAuthenticationProvider(OAuth2ConfigurerUtils.getRegisteredClientRepository(builder), OAuth2ConfigurerUtils.getAuthorizationService(builder), OAuth2ConfigurerUtils.getTokenGenerator(builder));
        builder.authenticationProvider((AuthenticationProvider)this.postProcess(oidcClientRegistrationAuthenticationProvider));
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void configure(B builder) {
        AuthenticationManager authenticationManager = (AuthenticationManager)builder.getSharedObject(AuthenticationManager.class);
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        OidcClientRegistrationEndpointFilter oidcClientRegistrationEndpointFilter = new OidcClientRegistrationEndpointFilter(authenticationManager, providerSettings.getOidcClientRegistrationEndpoint());
        builder.addFilterAfter((Filter)this.postProcess(oidcClientRegistrationEndpointFilter), FilterSecurityInterceptor.class);
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }
}

