/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.token;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenContext;
import org.springframework.util.Assert;

public final class DefaultOAuth2TokenContext
implements OAuth2TokenContext {
    private final Map<Object, Object> context;

    private DefaultOAuth2TokenContext(Map<Object, Object> context) {
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends OAuth2TokenContext.AbstractBuilder<DefaultOAuth2TokenContext, Builder> {
        private Builder() {
        }

        @Override
        public DefaultOAuth2TokenContext build() {
            return new DefaultOAuth2TokenContext(this.getContext());
        }
    }
}

