/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.token;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsSet;
import org.springframework.util.Assert;

public final class OAuth2TokenClaimsContext
implements OAuth2TokenContext {
    private final Map<Object, Object> context;

    private OAuth2TokenClaimsContext(Map<Object, Object> context) {
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }

    public OAuth2TokenClaimsSet.Builder getClaims() {
        return this.get(OAuth2TokenClaimsSet.Builder.class);
    }

    public static Builder with(OAuth2TokenClaimsSet.Builder claimsBuilder) {
        return new Builder(claimsBuilder);
    }

    public static final class Builder
    extends OAuth2TokenContext.AbstractBuilder<OAuth2TokenClaimsContext, Builder> {
        private Builder(OAuth2TokenClaimsSet.Builder claimsBuilder) {
            Assert.notNull((Object)claimsBuilder, (String)"claimsBuilder cannot be null");
            this.put(OAuth2TokenClaimsSet.Builder.class, claimsBuilder);
        }

        public Builder claims(Consumer<OAuth2TokenClaimsSet.Builder> claimsConsumer) {
            claimsConsumer.accept((OAuth2TokenClaimsSet.Builder)this.get(OAuth2TokenClaimsSet.Builder.class));
            return this;
        }

        @Override
        public OAuth2TokenClaimsContext build() {
            return new OAuth2TokenClaimsContext(this.getContext());
        }
    }
}

