/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenIntrospection;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.oauth2.core.http.converter.OAuth2TokenIntrospectionHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenIntrospectionAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public final class OAuth2TokenIntrospectionEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_TOKEN_INTROSPECTION_ENDPOINT_URI = "/oauth2/introspect";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher tokenIntrospectionEndpointMatcher;
    private AuthenticationConverter authenticationConverter = new DefaultTokenIntrospectionAuthenticationConverter();
    private final HttpMessageConverter<OAuth2TokenIntrospection> tokenIntrospectionHttpResponseConverter = new OAuth2TokenIntrospectionHttpMessageConverter();
    private final HttpMessageConverter<OAuth2Error> errorHttpResponseConverter = new OAuth2ErrorHttpMessageConverter();
    private AuthenticationSuccessHandler authenticationSuccessHandler = this::sendIntrospectionResponse;
    private AuthenticationFailureHandler authenticationFailureHandler = this::sendErrorResponse;

    public OAuth2TokenIntrospectionEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_TOKEN_INTROSPECTION_ENDPOINT_URI);
    }

    public OAuth2TokenIntrospectionEndpointFilter(AuthenticationManager authenticationManager, String tokenIntrospectionEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)tokenIntrospectionEndpointUri, (String)"tokenIntrospectionEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.tokenIntrospectionEndpointMatcher = new AntPathRequestMatcher(tokenIntrospectionEndpointUri, HttpMethod.POST.name());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.tokenIntrospectionEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication tokenIntrospectionAuthentication = this.authenticationConverter.convert(request);
            Authentication tokenIntrospectionAuthenticationResult = this.authenticationManager.authenticate(tokenIntrospectionAuthentication);
            this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, tokenIntrospectionAuthenticationResult);
        }
        catch (OAuth2AuthenticationException ex) {
            SecurityContextHolder.clearContext();
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)ex);
        }
    }

    public void setAuthenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    private void sendIntrospectionResponse(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        OAuth2TokenIntrospectionAuthenticationToken tokenIntrospectionAuthentication = (OAuth2TokenIntrospectionAuthenticationToken)authentication;
        OAuth2TokenIntrospection tokenClaims = tokenIntrospectionAuthentication.getTokenClaims();
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.tokenIntrospectionHttpResponseConverter.write((Object)tokenClaims, null, (HttpOutputMessage)httpResponse);
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2Error error = ((OAuth2AuthenticationException)exception).getError();
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode(HttpStatus.BAD_REQUEST);
        this.errorHttpResponseConverter.write((Object)error, null, (HttpOutputMessage)httpResponse);
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Token Introspection Parameter: " + parameterName, "https://datatracker.ietf.org/doc/html/rfc7662#section-2.1");
        throw new OAuth2AuthenticationException(error);
    }

    private static class DefaultTokenIntrospectionAuthenticationConverter
    implements AuthenticationConverter {
        private DefaultTokenIntrospectionAuthenticationConverter() {
        }

        public Authentication convert(HttpServletRequest request) {
            String tokenTypeHint;
            Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
            MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
            String token = (String)parameters.getFirst((Object)"token");
            if (!StringUtils.hasText((String)token) || ((List)parameters.get((Object)"token")).size() != 1) {
                OAuth2TokenIntrospectionEndpointFilter.throwError("invalid_request", "token");
            }
            if (StringUtils.hasText((String)(tokenTypeHint = (String)parameters.getFirst((Object)"token_type_hint"))) && ((List)parameters.get((Object)"token_type_hint")).size() != 1) {
                OAuth2TokenIntrospectionEndpointFilter.throwError("invalid_request", "token_type_hint");
            }
            HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
            parameters.forEach((key, value) -> {
                if (!key.equals("token") && !key.equals("token_type_hint")) {
                    additionalParameters.put((String)key, value.get(0));
                }
            });
            return new OAuth2TokenIntrospectionAuthenticationToken(token, clientPrincipal, tokenTypeHint, additionalParameters);
        }
    }
}

