/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2TokenIntrospection;
import org.springframework.security.oauth2.core.Version;
import org.springframework.util.Assert;

public class OAuth2TokenIntrospectionAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
    private final String token;
    private final Authentication clientPrincipal;
    private final String tokenTypeHint;
    private final Map<String, Object> additionalParameters;
    private final OAuth2TokenIntrospection tokenClaims;

    public OAuth2TokenIntrospectionAuthenticationToken(String token, Authentication clientPrincipal, @Nullable String tokenTypeHint, @Nullable Map<String, Object> additionalParameters) {
        super(Collections.emptyList());
        Assert.hasText((String)token, (String)"token cannot be empty");
        Assert.notNull((Object)clientPrincipal, (String)"clientPrincipal cannot be null");
        this.token = token;
        this.clientPrincipal = clientPrincipal;
        this.tokenTypeHint = tokenTypeHint;
        this.additionalParameters = Collections.unmodifiableMap(additionalParameters != null ? new HashMap<String, Object>(additionalParameters) : Collections.emptyMap());
        this.tokenClaims = OAuth2TokenIntrospection.builder().build();
    }

    public OAuth2TokenIntrospectionAuthenticationToken(String token, Authentication clientPrincipal, OAuth2TokenIntrospection tokenClaims) {
        super(Collections.emptyList());
        Assert.hasText((String)token, (String)"token cannot be empty");
        Assert.notNull((Object)clientPrincipal, (String)"clientPrincipal cannot be null");
        Assert.notNull((Object)tokenClaims, (String)"tokenClaims cannot be null");
        this.token = token;
        this.clientPrincipal = clientPrincipal;
        this.tokenTypeHint = null;
        this.additionalParameters = Collections.emptyMap();
        this.tokenClaims = tokenClaims;
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.clientPrincipal;
    }

    public Object getCredentials() {
        return "";
    }

    public String getToken() {
        return this.token;
    }

    @Nullable
    public String getTokenTypeHint() {
        return this.tokenTypeHint;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public OAuth2TokenIntrospection getTokenClaims() {
        return this.tokenClaims;
    }
}

