/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.Version;
import org.springframework.util.Assert;

public class OAuth2TokenRevocationAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
    private final String token;
    private final Authentication clientPrincipal;
    private final String tokenTypeHint;

    public OAuth2TokenRevocationAuthenticationToken(String token, Authentication clientPrincipal, @Nullable String tokenTypeHint) {
        super(Collections.emptyList());
        Assert.hasText((String)token, (String)"token cannot be empty");
        Assert.notNull((Object)clientPrincipal, (String)"clientPrincipal cannot be null");
        this.token = token;
        this.clientPrincipal = clientPrincipal;
        this.tokenTypeHint = tokenTypeHint;
    }

    public OAuth2TokenRevocationAuthenticationToken(OAuth2Token revokedToken, Authentication clientPrincipal) {
        super(Collections.emptyList());
        Assert.notNull((Object)revokedToken, (String)"revokedToken cannot be null");
        Assert.notNull((Object)clientPrincipal, (String)"clientPrincipal cannot be null");
        this.token = revokedToken.getTokenValue();
        this.clientPrincipal = clientPrincipal;
        this.tokenTypeHint = null;
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.clientPrincipal;
    }

    public Object getCredentials() {
        return "";
    }

    public String getToken() {
        return this.token;
    }

    @Nullable
    public String getTokenTypeHint() {
        return this.tokenTypeHint;
    }
}

