/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.authentication;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClaimAccessor;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.core.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ClientSettings;
import org.springframework.security.oauth2.server.authorization.config.TokenSettings;
import org.springframework.security.oauth2.server.authorization.context.ProviderContext;
import org.springframework.security.oauth2.server.authorization.context.ProviderContextHolder;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcAuthenticationProviderUtils;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.token.DefaultOAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public final class OidcClientRegistrationAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://openid.net/specs/openid-connect-registration-1_0.html#RegistrationError";
    private static final StringKeyGenerator CLIENT_ID_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 32);
    private static final StringKeyGenerator CLIENT_SECRET_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 48);
    private static final String DEFAULT_CLIENT_REGISTRATION_AUTHORIZED_SCOPE = "client.create";
    private static final String DEFAULT_CLIENT_CONFIGURATION_AUTHORIZED_SCOPE = "client.read";
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator;

    public OidcClientRegistrationAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService, OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.notNull(tokenGenerator, (String)"tokenGenerator cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        this.tokenGenerator = tokenGenerator;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication = (OidcClientRegistrationAuthenticationToken)authentication;
        AbstractOAuth2TokenAuthenticationToken accessTokenAuthentication = null;
        if (AbstractOAuth2TokenAuthenticationToken.class.isAssignableFrom(clientRegistrationAuthentication.getPrincipal().getClass())) {
            accessTokenAuthentication = (AbstractOAuth2TokenAuthenticationToken)clientRegistrationAuthentication.getPrincipal();
        }
        if (accessTokenAuthentication == null || !accessTokenAuthentication.isAuthenticated()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        String accessTokenValue = accessTokenAuthentication.getToken().getTokenValue();
        OAuth2Authorization authorization = this.authorizationService.findByToken(accessTokenValue, OAuth2TokenType.ACCESS_TOKEN);
        if (authorization == null) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken = authorization.getAccessToken();
        if (!authorizedAccessToken.isActive()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        return clientRegistrationAuthentication.getClientRegistration() != null ? this.registerClient(clientRegistrationAuthentication, authorization) : this.findRegistration(clientRegistrationAuthentication, authorization);
    }

    public boolean supports(Class<?> authentication) {
        return OidcClientRegistrationAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private OidcClientRegistrationAuthenticationToken findRegistration(OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication, OAuth2Authorization authorization) {
        OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken = authorization.getAccessToken();
        OidcClientRegistrationAuthenticationProvider.checkScopeForConfiguration(authorizedAccessToken);
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(clientRegistrationAuthentication.getClientId());
        if (registeredClient == null) {
            throw new OAuth2AuthenticationException("invalid_client");
        }
        if (!registeredClient.getId().equals(authorization.getRegisteredClientId())) {
            throw new OAuth2AuthenticationException("invalid_client");
        }
        OidcClientRegistration clientRegistration = this.buildRegistration(registeredClient).build();
        return new OidcClientRegistrationAuthenticationToken((Authentication)clientRegistrationAuthentication.getPrincipal(), clientRegistration);
    }

    private OidcClientRegistrationAuthenticationToken registerClient(OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication, OAuth2Authorization authorization) {
        OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken = authorization.getAccessToken();
        OidcClientRegistrationAuthenticationProvider.checkScopeForRegistration(authorizedAccessToken);
        if (!OidcClientRegistrationAuthenticationProvider.isValidRedirectUris(clientRegistrationAuthentication.getClientRegistration().getRedirectUris())) {
            OidcClientRegistrationAuthenticationProvider.throwInvalidClientRegistration("invalid_redirect_uri", "redirect_uris");
        }
        if (!OidcClientRegistrationAuthenticationProvider.isValidTokenEndpointAuthenticationMethod(clientRegistrationAuthentication.getClientRegistration())) {
            OidcClientRegistrationAuthenticationProvider.throwInvalidClientRegistration("invalid_client_metadata", "token_endpoint_auth_method");
        }
        RegisteredClient registeredClient = OidcClientRegistrationAuthenticationProvider.createClient(clientRegistrationAuthentication.getClientRegistration());
        this.registeredClientRepository.save(registeredClient);
        OAuth2Authorization registeredClientAuthorization = this.registerAccessToken(registeredClient);
        authorization = OidcAuthenticationProviderUtils.invalidate(authorization, authorizedAccessToken.getToken());
        if (authorization.getRefreshToken() != null) {
            authorization = OidcAuthenticationProviderUtils.invalidate(authorization, authorization.getRefreshToken().getToken());
        }
        this.authorizationService.save(authorization);
        OidcClientRegistration clientRegistration = this.buildRegistration(registeredClient).registrationAccessToken(registeredClientAuthorization.getAccessToken().getToken().getTokenValue()).build();
        return new OidcClientRegistrationAuthenticationToken((Authentication)clientRegistrationAuthentication.getPrincipal(), clientRegistration);
    }

    private OAuth2Authorization registerAccessToken(RegisteredClient registeredClient) {
        OAuth2ClientAuthenticationToken clientPrincipal = new OAuth2ClientAuthenticationToken(registeredClient, registeredClient.getClientAuthenticationMethods().iterator().next(), registeredClient.getClientSecret());
        HashSet<String> authorizedScopes = new HashSet<String>();
        authorizedScopes.add(DEFAULT_CLIENT_CONFIGURATION_AUTHORIZED_SCOPE);
        authorizedScopes = Collections.unmodifiableSet(authorizedScopes);
        DefaultOAuth2TokenContext tokenContext = ((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)DefaultOAuth2TokenContext.builder().registeredClient(registeredClient)).principal((Authentication)clientPrincipal)).providerContext(ProviderContextHolder.getProviderContext())).authorizedScopes(authorizedScopes)).tokenType(OAuth2TokenType.ACCESS_TOKEN)).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS)).build();
        OAuth2Token registrationAccessToken = this.tokenGenerator.generate(tokenContext);
        if (registrationAccessToken == null) {
            OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the registration access token.", ERROR_URI);
            throw new OAuth2AuthenticationException(error);
        }
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, registrationAccessToken.getTokenValue(), registrationAccessToken.getIssuedAt(), registrationAccessToken.getExpiresAt(), tokenContext.getAuthorizedScopes());
        OAuth2Authorization.Builder authorizationBuilder = OAuth2Authorization.withRegisteredClient(registeredClient).principalName(registeredClient.getClientId()).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).attribute(OAuth2Authorization.AUTHORIZED_SCOPE_ATTRIBUTE_NAME, authorizedScopes);
        if (registrationAccessToken instanceof ClaimAccessor) {
            authorizationBuilder.token(accessToken, metadata -> metadata.put(OAuth2Authorization.Token.CLAIMS_METADATA_NAME, ((ClaimAccessor)registrationAccessToken).getClaims()));
        } else {
            authorizationBuilder.accessToken(accessToken);
        }
        OAuth2Authorization authorization = authorizationBuilder.build();
        this.authorizationService.save(authorization);
        return authorization;
    }

    private OidcClientRegistration.Builder buildRegistration(RegisteredClient registeredClient) {
        OidcClientRegistration.Builder builder = OidcClientRegistration.builder().clientId(registeredClient.getClientId()).clientIdIssuedAt(registeredClient.getClientIdIssuedAt()).clientName(registeredClient.getClientName());
        if (registeredClient.getClientSecret() != null) {
            builder.clientSecret(registeredClient.getClientSecret());
        }
        builder.redirectUris(redirectUris -> redirectUris.addAll(registeredClient.getRedirectUris()));
        builder.grantTypes(grantTypes -> registeredClient.getAuthorizationGrantTypes().forEach(authorizationGrantType -> grantTypes.add(authorizationGrantType.getValue())));
        if (registeredClient.getAuthorizationGrantTypes().contains(AuthorizationGrantType.AUTHORIZATION_CODE)) {
            builder.responseType(OAuth2AuthorizationResponseType.CODE.getValue());
        }
        if (!CollectionUtils.isEmpty(registeredClient.getScopes())) {
            builder.scopes(scopes -> scopes.addAll(registeredClient.getScopes()));
        }
        ProviderContext providerContext = ProviderContextHolder.getProviderContext();
        String registrationClientUri = UriComponentsBuilder.fromUriString((String)providerContext.getIssuer()).path(providerContext.getProviderSettings().getOidcClientRegistrationEndpoint()).queryParam("client_id", new Object[]{registeredClient.getClientId()}).toUriString();
        builder.tokenEndpointAuthenticationMethod(registeredClient.getClientAuthenticationMethods().iterator().next().getValue()).idTokenSignedResponseAlgorithm(registeredClient.getTokenSettings().getIdTokenSignatureAlgorithm().getName()).registrationClientUrl(registrationClientUri);
        ClientSettings clientSettings = registeredClient.getClientSettings();
        if (clientSettings.getJwkSetUrl() != null) {
            builder.jwkSetUrl(clientSettings.getJwkSetUrl());
        }
        if (clientSettings.getTokenEndpointAuthenticationSigningAlgorithm() != null) {
            builder.tokenEndpointAuthenticationSigningAlgorithm(clientSettings.getTokenEndpointAuthenticationSigningAlgorithm().getName());
        }
        return builder;
    }

    private static void checkScopeForRegistration(OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken) {
        OidcClientRegistrationAuthenticationProvider.checkScope(authorizedAccessToken, Collections.singleton(DEFAULT_CLIENT_REGISTRATION_AUTHORIZED_SCOPE));
    }

    private static void checkScopeForConfiguration(OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken) {
        OidcClientRegistrationAuthenticationProvider.checkScope(authorizedAccessToken, Collections.singleton(DEFAULT_CLIENT_CONFIGURATION_AUTHORIZED_SCOPE));
    }

    private static void checkScope(OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken, Set<String> requiredScope) {
        Collection<Object> authorizedScope = Collections.emptySet();
        if (authorizedAccessToken.getClaims().containsKey("scope")) {
            authorizedScope = (Collection)authorizedAccessToken.getClaims().get("scope");
        }
        if (!authorizedScope.containsAll(requiredScope)) {
            throw new OAuth2AuthenticationException("insufficient_scope");
        }
        if (authorizedScope.size() != requiredScope.size()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
    }

    private static boolean isValidRedirectUris(List<String> redirectUris) {
        if (CollectionUtils.isEmpty(redirectUris)) {
            return true;
        }
        for (String redirectUri : redirectUris) {
            try {
                URI validRedirectUri = new URI(redirectUri);
                if (validRedirectUri.getFragment() == null) continue;
                return false;
            }
            catch (URISyntaxException ex) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidTokenEndpointAuthenticationMethod(OidcClientRegistration clientRegistration) {
        String authenticationMethod = clientRegistration.getTokenEndpointAuthenticationMethod();
        String authenticationSigningAlgorithm = clientRegistration.getTokenEndpointAuthenticationSigningAlgorithm();
        if (!ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue().equals(authenticationMethod) && !ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue().equals(authenticationMethod)) {
            return !StringUtils.hasText((String)authenticationSigningAlgorithm);
        }
        if ("none".equals(authenticationSigningAlgorithm)) {
            return false;
        }
        if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue().equals(authenticationMethod)) {
            return clientRegistration.getJwkSetUrl() != null && (!StringUtils.hasText((String)authenticationSigningAlgorithm) || SignatureAlgorithm.from((String)authenticationSigningAlgorithm) != null);
        }
        return !StringUtils.hasText((String)authenticationSigningAlgorithm) || MacAlgorithm.from((String)authenticationSigningAlgorithm) != null;
    }

    private static RegisteredClient createClient(OidcClientRegistration clientRegistration) {
        RegisteredClient.Builder builder = RegisteredClient.withId(UUID.randomUUID().toString()).clientId(CLIENT_ID_GENERATOR.generateKey()).clientIdIssuedAt(Instant.now()).clientName(clientRegistration.getClientName());
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).clientSecret(CLIENT_SECRET_GENERATOR.generateKey());
        } else if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_JWT).clientSecret(CLIENT_SECRET_GENERATOR.generateKey());
        } else if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        } else {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).clientSecret(CLIENT_SECRET_GENERATOR.generateKey());
        }
        builder.redirectUris(redirectUris -> redirectUris.addAll(clientRegistration.getRedirectUris()));
        if (!CollectionUtils.isEmpty(clientRegistration.getGrantTypes())) {
            builder.authorizationGrantTypes(authorizationGrantTypes -> clientRegistration.getGrantTypes().forEach(grantType -> authorizationGrantTypes.add(new AuthorizationGrantType(grantType))));
        } else {
            builder.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        }
        if (CollectionUtils.isEmpty(clientRegistration.getResponseTypes()) || clientRegistration.getResponseTypes().contains(OAuth2AuthorizationResponseType.CODE.getValue())) {
            builder.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            builder.scopes(scopes -> scopes.addAll(clientRegistration.getScopes()));
        }
        ClientSettings.Builder clientSettingsBuilder = ClientSettings.builder().requireProofKey(true).requireAuthorizationConsent(true);
        if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            MacAlgorithm macAlgorithm = MacAlgorithm.from((String)clientRegistration.getTokenEndpointAuthenticationSigningAlgorithm());
            if (macAlgorithm == null) {
                macAlgorithm = MacAlgorithm.HS256;
            }
            clientSettingsBuilder.tokenEndpointAuthenticationSigningAlgorithm((JwsAlgorithm)macAlgorithm);
        } else if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.from((String)clientRegistration.getTokenEndpointAuthenticationSigningAlgorithm());
            if (signatureAlgorithm == null) {
                signatureAlgorithm = SignatureAlgorithm.RS256;
            }
            clientSettingsBuilder.tokenEndpointAuthenticationSigningAlgorithm((JwsAlgorithm)signatureAlgorithm);
            clientSettingsBuilder.jwkSetUrl(clientRegistration.getJwkSetUrl().toString());
        }
        builder.clientSettings(clientSettingsBuilder.build()).tokenSettings(TokenSettings.builder().idTokenSignatureAlgorithm(SignatureAlgorithm.RS256).build());
        return builder.build();
    }

    private static void throwInvalidClientRegistration(String errorCode, String fieldName) {
        OAuth2Error error = new OAuth2Error(errorCode, "Invalid Client Registration: " + fieldName, ERROR_URI);
        throw new OAuth2AuthenticationException(error);
    }
}

