/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.token;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2TokenFormat;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwsHeader;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class JwtGenerator
implements OAuth2TokenGenerator<Jwt> {
    private final JwtEncoder jwtEncoder;
    private OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer;

    public JwtGenerator(JwtEncoder jwtEncoder) {
        Assert.notNull((Object)jwtEncoder, (String)"jwtEncoder cannot be null");
        this.jwtEncoder = jwtEncoder;
    }

    @Override
    @Nullable
    public Jwt generate(OAuth2TokenContext context) {
        if (context.getTokenType() == null || !OAuth2TokenType.ACCESS_TOKEN.equals(context.getTokenType()) && !"id_token".equals(context.getTokenType().getValue())) {
            return null;
        }
        if (OAuth2TokenType.ACCESS_TOKEN.equals(context.getTokenType()) && !OAuth2TokenFormat.SELF_CONTAINED.equals(context.getRegisteredClient().getTokenSettings().getAccessTokenFormat())) {
            return null;
        }
        String issuer = null;
        if (context.getProviderContext() != null) {
            issuer = context.getProviderContext().getIssuer();
        }
        RegisteredClient registeredClient = context.getRegisteredClient();
        Instant issuedAt = Instant.now();
        Instant expiresAt = "id_token".equals(context.getTokenType().getValue()) ? issuedAt.plus(30L, ChronoUnit.MINUTES) : issuedAt.plus(registeredClient.getTokenSettings().getAccessTokenTimeToLive());
        JwtClaimsSet.Builder claimsBuilder = JwtClaimsSet.builder();
        if (StringUtils.hasText((String)issuer)) {
            claimsBuilder.issuer(issuer);
        }
        claimsBuilder.subject(context.getPrincipal().getName()).audience(Collections.singletonList(registeredClient.getClientId())).issuedAt(issuedAt).expiresAt(expiresAt);
        if (OAuth2TokenType.ACCESS_TOKEN.equals(context.getTokenType())) {
            claimsBuilder.notBefore(issuedAt);
            if (!CollectionUtils.isEmpty(context.getAuthorizedScopes())) {
                claimsBuilder.claim("scope", context.getAuthorizedScopes());
            }
        } else if ("id_token".equals(context.getTokenType().getValue())) {
            OAuth2AuthorizationRequest authorizationRequest;
            String nonce;
            claimsBuilder.claim("azp", (Object)registeredClient.getClientId());
            if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)context.getAuthorizationGrantType()) && StringUtils.hasText((String)(nonce = (String)(authorizationRequest = (OAuth2AuthorizationRequest)context.getAuthorization().getAttribute(OAuth2AuthorizationRequest.class.getName())).getAdditionalParameters().get("nonce")))) {
                claimsBuilder.claim("nonce", (Object)nonce);
            }
        }
        JwsHeader.Builder headersBuilder = JwsHeader.with((JwsAlgorithm)SignatureAlgorithm.RS256);
        if (this.jwtCustomizer != null) {
            JwtEncodingContext.Builder jwtContextBuilder = (JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)JwtEncodingContext.with(headersBuilder, claimsBuilder).registeredClient(context.getRegisteredClient())).principal((Authentication)context.getPrincipal())).providerContext(context.getProviderContext())).authorizedScopes(context.getAuthorizedScopes())).tokenType(context.getTokenType())).authorizationGrantType(context.getAuthorizationGrantType());
            if (context.getAuthorization() != null) {
                jwtContextBuilder.authorization(context.getAuthorization());
            }
            if (context.getAuthorizationGrant() != null) {
                jwtContextBuilder.authorizationGrant((Authentication)context.getAuthorizationGrant());
            }
            JwtEncodingContext jwtContext = jwtContextBuilder.build();
            this.jwtCustomizer.customize(jwtContext);
        }
        JwsHeader headers = headersBuilder.build();
        JwtClaimsSet claims = claimsBuilder.build();
        Jwt jwt = this.jwtEncoder.encode(JwtEncoderParameters.from((JwsHeader)headers, (JwtClaimsSet)claims));
        return jwt;
    }

    public void setJwtCustomizer(OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer) {
        Assert.notNull(jwtCustomizer, (String)"jwtCustomizer cannot be null");
        this.jwtCustomizer = jwtCustomizer;
    }
}

