/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web.authentication;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.http.converter.OidcClientRegistrationHttpMessageConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OidcClientRegistrationAuthenticationConverter
implements AuthenticationConverter {
    private final HttpMessageConverter<OidcClientRegistration> clientRegistrationHttpMessageConverter = new OidcClientRegistrationHttpMessageConverter();

    public Authentication convert(HttpServletRequest request) {
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        if ("POST".equals(request.getMethod())) {
            OidcClientRegistration clientRegistration;
            try {
                clientRegistration = (OidcClientRegistration)this.clientRegistrationHttpMessageConverter.read(OidcClientRegistration.class, (HttpInputMessage)new ServletServerHttpRequest(request));
            }
            catch (Exception ex) {
                OAuth2Error error = new OAuth2Error("invalid_request", "OpenID Client Registration Error: " + ex.getMessage(), "https://openid.net/specs/openid-connect-registration-1_0.html#RegistrationError");
                throw new OAuth2AuthenticationException(error, (Throwable)ex);
            }
            return new OidcClientRegistrationAuthenticationToken(principal, clientRegistration);
        }
        MultiValueMap<String, String> parameters = OidcClientRegistrationAuthenticationConverter.getQueryParameters(request);
        String clientId = (String)parameters.getFirst((Object)"client_id");
        if (!StringUtils.hasText((String)clientId) || ((List)parameters.get((Object)"client_id")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        return new OidcClientRegistrationAuthenticationToken(principal, clientId);
    }

    private static MultiValueMap<String, String> getQueryParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameterMap.forEach((arg_0, arg_1) -> OidcClientRegistrationAuthenticationConverter.lambda$getQueryParameters$0(request, (MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    private static /* synthetic */ void lambda$getQueryParameters$0(HttpServletRequest request, MultiValueMap parameters, String key, String[] values) {
        String queryString;
        String string = queryString = StringUtils.hasText((String)request.getQueryString()) ? request.getQueryString() : "";
        if (queryString.contains(key) && values.length > 0) {
            for (String value : values) {
                parameters.add((Object)key, (Object)value);
            }
        }
    }
}

