/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class JwtClientAssertionAuthenticationConverter
implements AuthenticationConverter {
    private static final ClientAuthenticationMethod JWT_CLIENT_ASSERTION_AUTHENTICATION_METHOD = new ClientAuthenticationMethod("urn:ietf:params:oauth:client-assertion-type:jwt-bearer");

    @Nullable
    public Authentication convert(HttpServletRequest request) {
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getFormParameters(request);
        if (parameters.getFirst((Object)"client_assertion_type") == null || parameters.getFirst((Object)"client_assertion") == null) {
            return null;
        }
        String clientAssertionType = (String)parameters.getFirst((Object)"client_assertion_type");
        if (((List)parameters.get((Object)"client_assertion_type")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        if (!JWT_CLIENT_ASSERTION_AUTHENTICATION_METHOD.getValue().equals(clientAssertionType)) {
            return null;
        }
        String jwtAssertion = (String)parameters.getFirst((Object)"client_assertion");
        if (((List)parameters.get((Object)"client_assertion")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        String clientId = (String)parameters.getFirst((Object)"client_id");
        if (!StringUtils.hasText((String)clientId) || ((List)parameters.get((Object)"client_id")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        Map<String, Object> additionalParameters = OAuth2EndpointUtils.getParametersIfMatchesAuthorizationCodeGrantRequest(request, "client_assertion_type", "client_assertion", "client_id");
        return new OAuth2ClientAuthenticationToken(clientId, JWT_CLIENT_ASSERTION_AUTHENTICATION_METHOD, jwtAssertion, additionalParameters);
    }
}

