/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class PublicClientAuthenticationConverter
implements AuthenticationConverter {
    @Nullable
    public Authentication convert(HttpServletRequest request) {
        if (!OAuth2EndpointUtils.matchesPkceTokenRequest(request)) {
            return null;
        }
        MultiValueMap<String, String> parameters = "GET".equals(request.getMethod()) ? OAuth2EndpointUtils.getQueryParameters(request) : OAuth2EndpointUtils.getFormParameters(request);
        String clientId = (String)parameters.getFirst((Object)"client_id");
        if (!StringUtils.hasText((String)clientId) || ((List)parameters.get((Object)"client_id")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        if (((List)parameters.get((Object)"code_verifier")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        parameters.remove((Object)"client_id");
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> additionalParameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0])));
        return new OAuth2ClientAuthenticationToken(clientId, ClientAuthenticationMethod.NONE, null, additionalParameters);
    }
}

